package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.honeycode.model.primitives.{WorkbookCursor, BatchItemId}
import scala.jdk.CollectionConverters.*
final case class BatchUpsertTableRowsResponse(
    rows: Map[BatchItemId, zio.aws.honeycode.model.UpsertRowsResult],
    workbookCursor: WorkbookCursor,
    failedBatchItems: Option[
      Iterable[zio.aws.honeycode.model.FailedBatchItem]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.BatchUpsertTableRowsResponse = {
    import BatchUpsertTableRowsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.BatchUpsertTableRowsResponse
      .builder()
      .rows(
        rows
          .map({ case (key, value) =>
            (BatchItemId.unwrap(key): java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .workbookCursor(WorkbookCursor.unwrap(workbookCursor): java.lang.Long)
      .optionallyWith(
        failedBatchItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedBatchItems)
      .build()
  }
  def asReadOnly
      : zio.aws.honeycode.model.BatchUpsertTableRowsResponse.ReadOnly =
    zio.aws.honeycode.model.BatchUpsertTableRowsResponse.wrap(buildAwsValue())
}
object BatchUpsertTableRowsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.BatchUpsertTableRowsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.BatchUpsertTableRowsResponse =
      zio.aws.honeycode.model.BatchUpsertTableRowsResponse(
        rows.map({ case (key, value) =>
          key -> value.asEditable
        }),
        workbookCursor,
        failedBatchItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def rows
        : Map[BatchItemId, zio.aws.honeycode.model.UpsertRowsResult.ReadOnly]
    def workbookCursor: WorkbookCursor
    def failedBatchItems
        : Option[List[zio.aws.honeycode.model.FailedBatchItem.ReadOnly]]
    def getRows: ZIO[Any, Nothing, Map[
      BatchItemId,
      zio.aws.honeycode.model.UpsertRowsResult.ReadOnly
    ]] = ZIO.succeed(rows)
    def getWorkbookCursor: ZIO[Any, Nothing, WorkbookCursor] =
      ZIO.succeed(workbookCursor)
    def getFailedBatchItems: ZIO[Any, AwsError, List[
      zio.aws.honeycode.model.FailedBatchItem.ReadOnly
    ]] = AwsError.unwrapOptionField("failedBatchItems", failedBatchItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.BatchUpsertTableRowsResponse
  ) extends zio.aws.honeycode.model.BatchUpsertTableRowsResponse.ReadOnly {
    override val rows
        : Map[BatchItemId, zio.aws.honeycode.model.UpsertRowsResult.ReadOnly] =
      impl
        .rows()
        .asScala
        .map({ case (key, value) =>
          zio.aws.honeycode.model.primitives.BatchItemId(
            key
          ) -> zio.aws.honeycode.model.UpsertRowsResult.wrap(value)
        })
        .toMap
    override val workbookCursor: WorkbookCursor =
      zio.aws.honeycode.model.primitives.WorkbookCursor(impl.workbookCursor())
    override val failedBatchItems
        : Option[List[zio.aws.honeycode.model.FailedBatchItem.ReadOnly]] = scala
      .Option(impl.failedBatchItems())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.honeycode.model.FailedBatchItem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.BatchUpsertTableRowsResponse
  ): zio.aws.honeycode.model.BatchUpsertTableRowsResponse.ReadOnly =
    new Wrapper(impl)
}
