package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.honeycode.model.primitives.RowId
import scala.jdk.CollectionConverters.*
final case class UpsertRowsResult(
    rowIds: Iterable[RowId],
    upsertAction: zio.aws.honeycode.model.UpsertAction
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.UpsertRowsResult = {
    import UpsertRowsResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.UpsertRowsResult
      .builder()
      .rowIds(rowIds.map { item =>
        RowId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .upsertAction(upsertAction.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.UpsertRowsResult.ReadOnly =
    zio.aws.honeycode.model.UpsertRowsResult.wrap(buildAwsValue())
}
object UpsertRowsResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.UpsertRowsResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.UpsertRowsResult =
      zio.aws.honeycode.model.UpsertRowsResult(rowIds, upsertAction)
    def rowIds: List[RowId]
    def upsertAction: zio.aws.honeycode.model.UpsertAction
    def getRowIds: ZIO[Any, Nothing, List[RowId]] = ZIO.succeed(rowIds)
    def getUpsertAction
        : ZIO[Any, Nothing, zio.aws.honeycode.model.UpsertAction] =
      ZIO.succeed(upsertAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.UpsertRowsResult
  ) extends zio.aws.honeycode.model.UpsertRowsResult.ReadOnly {
    override val rowIds: List[RowId] = impl
      .rowIds()
      .asScala
      .map { item =>
        zio.aws.honeycode.model.primitives.RowId(item)
      }
      .toList
    override val upsertAction: zio.aws.honeycode.model.UpsertAction =
      zio.aws.honeycode.model.UpsertAction.wrap(impl.upsertAction())
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.UpsertRowsResult
  ): zio.aws.honeycode.model.UpsertRowsResult.ReadOnly = new Wrapper(impl)
}
