package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.honeycode.model.primitives.{
  PaginationToken,
  WorkbookCursor,
  Name
}
import scala.jdk.CollectionConverters.*
final case class GetScreenDataResponse(
    results: Map[Name, zio.aws.honeycode.model.ResultSet],
    workbookCursor: WorkbookCursor,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.GetScreenDataResponse = {
    import GetScreenDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.GetScreenDataResponse
      .builder()
      .results(
        results
          .map({ case (key, value) =>
            (Name.unwrap(key): java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .workbookCursor(WorkbookCursor.unwrap(workbookCursor): java.lang.Long)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.GetScreenDataResponse.ReadOnly =
    zio.aws.honeycode.model.GetScreenDataResponse.wrap(buildAwsValue())
}
object GetScreenDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.GetScreenDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.GetScreenDataResponse =
      zio.aws.honeycode.model.GetScreenDataResponse(
        results.map({ case (key, value) =>
          key -> value.asEditable
        }),
        workbookCursor,
        nextToken.map(value => value)
      )
    def results: Map[Name, zio.aws.honeycode.model.ResultSet.ReadOnly]
    def workbookCursor: WorkbookCursor
    def nextToken: Option[PaginationToken]
    def getResults: ZIO[Any, Nothing, Map[
      Name,
      zio.aws.honeycode.model.ResultSet.ReadOnly
    ]] = ZIO.succeed(results)
    def getWorkbookCursor: ZIO[Any, Nothing, WorkbookCursor] =
      ZIO.succeed(workbookCursor)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.GetScreenDataResponse
  ) extends zio.aws.honeycode.model.GetScreenDataResponse.ReadOnly {
    override val results
        : Map[Name, zio.aws.honeycode.model.ResultSet.ReadOnly] = impl
      .results()
      .asScala
      .map({ case (key, value) =>
        zio.aws.honeycode.model.primitives
          .Name(key) -> zio.aws.honeycode.model.ResultSet.wrap(value)
      })
      .toMap
    override val workbookCursor: WorkbookCursor =
      zio.aws.honeycode.model.primitives.WorkbookCursor(impl.workbookCursor())
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.honeycode.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.GetScreenDataResponse
  ): zio.aws.honeycode.model.GetScreenDataResponse.ReadOnly = new Wrapper(impl)
}
