package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.honeycode.model.primitives.{ClientRequestToken, ResourceId}
import scala.jdk.CollectionConverters.*
final case class BatchUpdateTableRowsRequest(
    workbookId: ResourceId,
    tableId: ResourceId,
    rowsToUpdate: Iterable[zio.aws.honeycode.model.UpdateRowData],
    clientRequestToken: Option[ClientRequestToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.BatchUpdateTableRowsRequest = {
    import BatchUpdateTableRowsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.BatchUpdateTableRowsRequest
      .builder()
      .workbookId(ResourceId.unwrap(workbookId): java.lang.String)
      .tableId(ResourceId.unwrap(tableId): java.lang.String)
      .rowsToUpdate(rowsToUpdate.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.BatchUpdateTableRowsRequest.ReadOnly =
    zio.aws.honeycode.model.BatchUpdateTableRowsRequest.wrap(buildAwsValue())
}
object BatchUpdateTableRowsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.BatchUpdateTableRowsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.BatchUpdateTableRowsRequest =
      zio.aws.honeycode.model.BatchUpdateTableRowsRequest(
        workbookId,
        tableId,
        rowsToUpdate.map { item =>
          item.asEditable
        },
        clientRequestToken.map(value => value)
      )
    def workbookId: ResourceId
    def tableId: ResourceId
    def rowsToUpdate: List[zio.aws.honeycode.model.UpdateRowData.ReadOnly]
    def clientRequestToken: Option[ClientRequestToken]
    def getWorkbookId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(workbookId)
    def getTableId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(tableId)
    def getRowsToUpdate: ZIO[Any, Nothing, List[
      zio.aws.honeycode.model.UpdateRowData.ReadOnly
    ]] = ZIO.succeed(rowsToUpdate)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.BatchUpdateTableRowsRequest
  ) extends zio.aws.honeycode.model.BatchUpdateTableRowsRequest.ReadOnly {
    override val workbookId: ResourceId =
      zio.aws.honeycode.model.primitives.ResourceId(impl.workbookId())
    override val tableId: ResourceId =
      zio.aws.honeycode.model.primitives.ResourceId(impl.tableId())
    override val rowsToUpdate
        : List[zio.aws.honeycode.model.UpdateRowData.ReadOnly] = impl
      .rowsToUpdate()
      .asScala
      .map { item =>
        zio.aws.honeycode.model.UpdateRowData.wrap(item)
      }
      .toList
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.honeycode.model.primitives.ClientRequestToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.BatchUpdateTableRowsRequest
  ): zio.aws.honeycode.model.BatchUpdateTableRowsRequest.ReadOnly = new Wrapper(
    impl
  )
}
