package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.honeycode.model.primitives.{ResourceId, BatchItemId}
import scala.jdk.CollectionConverters.*
final case class UpsertRowData(
    batchItemId: BatchItemId,
    filter: zio.aws.honeycode.model.Filter,
    cellsToUpdate: Map[ResourceId, zio.aws.honeycode.model.CellInput]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.UpsertRowData = {
    import UpsertRowData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.UpsertRowData
      .builder()
      .batchItemId(BatchItemId.unwrap(batchItemId): java.lang.String)
      .filter(filter.buildAwsValue())
      .cellsToUpdate(
        cellsToUpdate
          .map({ case (key, value) =>
            (ResourceId.unwrap(key): java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.UpsertRowData.ReadOnly =
    zio.aws.honeycode.model.UpsertRowData.wrap(buildAwsValue())
}
object UpsertRowData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.UpsertRowData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.UpsertRowData =
      zio.aws.honeycode.model.UpsertRowData(
        batchItemId,
        filter.asEditable,
        cellsToUpdate.map({ case (key, value) =>
          key -> value.asEditable
        })
      )
    def batchItemId: BatchItemId
    def filter: zio.aws.honeycode.model.Filter.ReadOnly
    def cellsToUpdate
        : Map[ResourceId, zio.aws.honeycode.model.CellInput.ReadOnly]
    def getBatchItemId: ZIO[Any, Nothing, BatchItemId] =
      ZIO.succeed(batchItemId)
    def getFilter: ZIO[Any, Nothing, zio.aws.honeycode.model.Filter.ReadOnly] =
      ZIO.succeed(filter)
    def getCellsToUpdate: ZIO[Any, Nothing, Map[
      ResourceId,
      zio.aws.honeycode.model.CellInput.ReadOnly
    ]] = ZIO.succeed(cellsToUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.UpsertRowData
  ) extends zio.aws.honeycode.model.UpsertRowData.ReadOnly {
    override val batchItemId: BatchItemId =
      zio.aws.honeycode.model.primitives.BatchItemId(impl.batchItemId())
    override val filter: zio.aws.honeycode.model.Filter.ReadOnly =
      zio.aws.honeycode.model.Filter.wrap(impl.filter())
    override val cellsToUpdate
        : Map[ResourceId, zio.aws.honeycode.model.CellInput.ReadOnly] = impl
      .cellsToUpdate()
      .asScala
      .map({ case (key, value) =>
        zio.aws.honeycode.model.primitives
          .ResourceId(key) -> zio.aws.honeycode.model.CellInput.wrap(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.UpsertRowData
  ): zio.aws.honeycode.model.UpsertRowData.ReadOnly = new Wrapper(impl)
}
