package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.honeycode.model.primitives.TableDataImportJobMessage
import scala.jdk.CollectionConverters.*
final case class DescribeTableDataImportJobResponse(
    jobStatus: zio.aws.honeycode.model.TableDataImportJobStatus,
    message: TableDataImportJobMessage,
    jobMetadata: zio.aws.honeycode.model.TableDataImportJobMetadata,
    errorCode: Option[zio.aws.honeycode.model.ErrorCode] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.DescribeTableDataImportJobResponse = {
    import DescribeTableDataImportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.DescribeTableDataImportJobResponse
      .builder()
      .jobStatus(jobStatus.unwrap)
      .message(TableDataImportJobMessage.unwrap(message): java.lang.String)
      .jobMetadata(jobMetadata.buildAwsValue())
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .build()
  }
  def asReadOnly
      : zio.aws.honeycode.model.DescribeTableDataImportJobResponse.ReadOnly =
    zio.aws.honeycode.model.DescribeTableDataImportJobResponse
      .wrap(buildAwsValue())
}
object DescribeTableDataImportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.DescribeTableDataImportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.DescribeTableDataImportJobResponse =
      zio.aws.honeycode.model.DescribeTableDataImportJobResponse(
        jobStatus,
        message,
        jobMetadata.asEditable,
        errorCode.map(value => value)
      )
    def jobStatus: zio.aws.honeycode.model.TableDataImportJobStatus
    def message: TableDataImportJobMessage
    def jobMetadata: zio.aws.honeycode.model.TableDataImportJobMetadata.ReadOnly
    def errorCode: Option[zio.aws.honeycode.model.ErrorCode]
    def getJobStatus
        : ZIO[Any, Nothing, zio.aws.honeycode.model.TableDataImportJobStatus] =
      ZIO.succeed(jobStatus)
    def getMessage: ZIO[Any, Nothing, TableDataImportJobMessage] =
      ZIO.succeed(message)
    def getJobMetadata: ZIO[
      Any,
      Nothing,
      zio.aws.honeycode.model.TableDataImportJobMetadata.ReadOnly
    ] = ZIO.succeed(jobMetadata)
    def getErrorCode: ZIO[Any, AwsError, zio.aws.honeycode.model.ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.DescribeTableDataImportJobResponse
  ) extends zio.aws.honeycode.model.DescribeTableDataImportJobResponse.ReadOnly {
    override val jobStatus: zio.aws.honeycode.model.TableDataImportJobStatus =
      zio.aws.honeycode.model.TableDataImportJobStatus.wrap(impl.jobStatus())
    override val message: TableDataImportJobMessage =
      zio.aws.honeycode.model.primitives
        .TableDataImportJobMessage(impl.message())
    override val jobMetadata
        : zio.aws.honeycode.model.TableDataImportJobMetadata.ReadOnly =
      zio.aws.honeycode.model.TableDataImportJobMetadata
        .wrap(impl.jobMetadata())
    override val errorCode: Option[zio.aws.honeycode.model.ErrorCode] = scala
      .Option(impl.errorCode())
      .map(value => zio.aws.honeycode.model.ErrorCode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.DescribeTableDataImportJobResponse
  ): zio.aws.honeycode.model.DescribeTableDataImportJobResponse.ReadOnly =
    new Wrapper(impl)
}
