package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ImportOptions(
    destinationOptions: Option[zio.aws.honeycode.model.DestinationOptions] =
      None,
    delimitedTextOptions: Option[
      zio.aws.honeycode.model.DelimitedTextImportOptions
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.ImportOptions = {
    import ImportOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.ImportOptions
      .builder()
      .optionallyWith(destinationOptions.map(value => value.buildAwsValue()))(
        _.destinationOptions
      )
      .optionallyWith(delimitedTextOptions.map(value => value.buildAwsValue()))(
        _.delimitedTextOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.ImportOptions.ReadOnly =
    zio.aws.honeycode.model.ImportOptions.wrap(buildAwsValue())
}
object ImportOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.ImportOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.ImportOptions =
      zio.aws.honeycode.model.ImportOptions(
        destinationOptions.map(value => value.asEditable),
        delimitedTextOptions.map(value => value.asEditable)
      )
    def destinationOptions
        : Option[zio.aws.honeycode.model.DestinationOptions.ReadOnly]
    def delimitedTextOptions
        : Option[zio.aws.honeycode.model.DelimitedTextImportOptions.ReadOnly]
    def getDestinationOptions: ZIO[
      Any,
      AwsError,
      zio.aws.honeycode.model.DestinationOptions.ReadOnly
    ] = AwsError.unwrapOptionField("destinationOptions", destinationOptions)
    def getDelimitedTextOptions: ZIO[
      Any,
      AwsError,
      zio.aws.honeycode.model.DelimitedTextImportOptions.ReadOnly
    ] = AwsError.unwrapOptionField("delimitedTextOptions", delimitedTextOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.ImportOptions
  ) extends zio.aws.honeycode.model.ImportOptions.ReadOnly {
    override val destinationOptions
        : Option[zio.aws.honeycode.model.DestinationOptions.ReadOnly] = scala
      .Option(impl.destinationOptions())
      .map(value => zio.aws.honeycode.model.DestinationOptions.wrap(value))
    override val delimitedTextOptions
        : Option[zio.aws.honeycode.model.DelimitedTextImportOptions.ReadOnly] =
      scala
        .Option(impl.delimitedTextOptions())
        .map(value =>
          zio.aws.honeycode.model.DelimitedTextImportOptions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.ImportOptions
  ): zio.aws.honeycode.model.ImportOptions.ReadOnly = new Wrapper(impl)
}
