package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.honeycode.model.primitives.RowId
import scala.jdk.CollectionConverters.*
final case class ResultRow(
    rowId: Option[RowId] = None,
    dataItems: Iterable[zio.aws.honeycode.model.DataItem]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.ResultRow = {
    import ResultRow.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.ResultRow
      .builder()
      .optionallyWith(
        rowId.map(value => RowId.unwrap(value): java.lang.String)
      )(_.rowId)
      .dataItems(dataItems.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.ResultRow.ReadOnly =
    zio.aws.honeycode.model.ResultRow.wrap(buildAwsValue())
}
object ResultRow {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.ResultRow
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.ResultRow =
      zio.aws.honeycode.model.ResultRow(
        rowId.map(value => value),
        dataItems.map { item =>
          item.asEditable
        }
      )
    def rowId: Option[RowId]
    def dataItems: List[zio.aws.honeycode.model.DataItem.ReadOnly]
    def getRowId: ZIO[Any, AwsError, RowId] =
      AwsError.unwrapOptionField("rowId", rowId)
    def getDataItems
        : ZIO[Any, Nothing, List[zio.aws.honeycode.model.DataItem.ReadOnly]] =
      ZIO.succeed(dataItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.ResultRow
  ) extends zio.aws.honeycode.model.ResultRow.ReadOnly {
    override val rowId: Option[RowId] = scala
      .Option(impl.rowId())
      .map(value => zio.aws.honeycode.model.primitives.RowId(value))
    override val dataItems: List[zio.aws.honeycode.model.DataItem.ReadOnly] =
      impl
        .dataItems()
        .asScala
        .map { item =>
          zio.aws.honeycode.model.DataItem.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.ResultRow
  ): zio.aws.honeycode.model.ResultRow.ReadOnly = new Wrapper(impl)
}
