package zio.aws.honeycode
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.honeycode.model.primitives.{
  VariableName,
  BatchItemId,
  Name,
  ResourceId,
  RowId
}
import zio.aws.honeycode.model.primitives.ResourceId.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AwsUserArn extends Subtype[String]
    type AwsUserArn = zio.aws.honeycode.model.primitives.AwsUserArn.Type
    object BatchErrorMessage extends Subtype[String]
    type BatchErrorMessage =
      zio.aws.honeycode.model.primitives.BatchErrorMessage.Type
    object BatchItemId extends Subtype[String]
    type BatchItemId = zio.aws.honeycode.model.primitives.BatchItemId.Type
    object ClientRequestToken extends Subtype[String]
    type ClientRequestToken =
      zio.aws.honeycode.model.primitives.ClientRequestToken.Type
    object DelimitedTextDelimiter extends Subtype[String]
    type DelimitedTextDelimiter =
      zio.aws.honeycode.model.primitives.DelimitedTextDelimiter.Type
    object Email extends Subtype[String]
    type Email = zio.aws.honeycode.model.primitives.Email.Type
    object Fact extends Subtype[String]
    type Fact = zio.aws.honeycode.model.primitives.Fact.Type
    object FormattedValue extends Subtype[String]
    type FormattedValue = zio.aws.honeycode.model.primitives.FormattedValue.Type
    object Formula extends Subtype[String]
    type Formula = zio.aws.honeycode.model.primitives.Formula.Type
    object HasHeaderRow extends Subtype[Boolean]
    type HasHeaderRow = zio.aws.honeycode.model.primitives.HasHeaderRow.Type
    object IgnoreEmptyRows extends Subtype[Boolean]
    type IgnoreEmptyRows =
      zio.aws.honeycode.model.primitives.IgnoreEmptyRows.Type
    object JobId extends Subtype[String]
    type JobId = zio.aws.honeycode.model.primitives.JobId.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.honeycode.model.primitives.MaxResults.Type
    object Name extends Subtype[String]
    type Name = zio.aws.honeycode.model.primitives.Name.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken =
      zio.aws.honeycode.model.primitives.PaginationToken.Type
    object RawValue extends Subtype[String]
    type RawValue = zio.aws.honeycode.model.primitives.RawValue.Type
    object ResourceId extends Subtype[String]
    type ResourceId = zio.aws.honeycode.model.primitives.ResourceId.Type
    object RowId extends Subtype[String]
    type RowId = zio.aws.honeycode.model.primitives.RowId.Type
    object SecureURL extends Subtype[String]
    type SecureURL = zio.aws.honeycode.model.primitives.SecureURL.Type
    object SourceDataColumnIndex extends Subtype[Int]
    type SourceDataColumnIndex =
      zio.aws.honeycode.model.primitives.SourceDataColumnIndex.Type
    object TableColumnName extends Subtype[String]
    type TableColumnName =
      zio.aws.honeycode.model.primitives.TableColumnName.Type
    object TableDataImportJobMessage extends Subtype[String]
    type TableDataImportJobMessage =
      zio.aws.honeycode.model.primitives.TableDataImportJobMessage.Type
    object TableName extends Subtype[String]
    type TableName = zio.aws.honeycode.model.primitives.TableName.Type
    object TimestampInMillis extends Subtype[Instant]
    type TimestampInMillis =
      zio.aws.honeycode.model.primitives.TimestampInMillis.Type
    object VariableName extends Subtype[String]
    type VariableName = zio.aws.honeycode.model.primitives.VariableName.Type
    object WorkbookCursor extends Subtype[Long]
    type WorkbookCursor = zio.aws.honeycode.model.primitives.WorkbookCursor.Type
  }
  type Cells = List[zio.aws.honeycode.model.Cell]
  type CreateRowDataList = List[zio.aws.honeycode.model.CreateRowData]
  type CreatedRowsMap = Map[BatchItemId, RowId]
  type DataItems = List[zio.aws.honeycode.model.DataItem]
  type FailedBatchItems = List[zio.aws.honeycode.model.FailedBatchItem]
  type ImportColumnMap =
    Map[ResourceId, zio.aws.honeycode.model.SourceDataColumnProperties]
  type ResourceIds = List[ResourceId]
  type ResultHeader = List[zio.aws.honeycode.model.ColumnMetadata]
  type ResultRows = List[zio.aws.honeycode.model.ResultRow]
  type ResultSetMap = Map[Name, zio.aws.honeycode.model.ResultSet]
  type RowDataInput = Map[ResourceId, zio.aws.honeycode.model.CellInput]
  type RowIdList = List[RowId]
  type TableColumns = List[zio.aws.honeycode.model.TableColumn]
  type TableRows = List[zio.aws.honeycode.model.TableRow]
  type Tables = List[zio.aws.honeycode.model.Table]
  type UpdateRowDataList = List[zio.aws.honeycode.model.UpdateRowData]
  type UpsertRowDataList = List[zio.aws.honeycode.model.UpsertRowData]
  type UpsertRowsResultMap =
    Map[BatchItemId, zio.aws.honeycode.model.UpsertRowsResult]
  type VariableValueMap =
    Map[VariableName, zio.aws.honeycode.model.VariableValue]
}
