package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.honeycode.model.primitives.RowId
import scala.jdk.CollectionConverters.*
final case class TableRow(
    rowId: RowId,
    cells: Iterable[zio.aws.honeycode.model.Cell]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.TableRow = {
    import TableRow.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.TableRow
      .builder()
      .rowId(RowId.unwrap(rowId): java.lang.String)
      .cells(cells.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.TableRow.ReadOnly =
    zio.aws.honeycode.model.TableRow.wrap(buildAwsValue())
}
object TableRow {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.TableRow
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.TableRow =
      zio.aws.honeycode.model.TableRow(
        rowId,
        cells.map { item =>
          item.asEditable
        }
      )
    def rowId: RowId
    def cells: List[zio.aws.honeycode.model.Cell.ReadOnly]
    def getRowId: ZIO[Any, Nothing, RowId] = ZIO.succeed(rowId)
    def getCells
        : ZIO[Any, Nothing, List[zio.aws.honeycode.model.Cell.ReadOnly]] =
      ZIO.succeed(cells)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.TableRow
  ) extends zio.aws.honeycode.model.TableRow.ReadOnly {
    override val rowId: RowId =
      zio.aws.honeycode.model.primitives.RowId(impl.rowId())
    override val cells: List[zio.aws.honeycode.model.Cell.ReadOnly] = impl
      .cells()
      .asScala
      .map { item =>
        zio.aws.honeycode.model.Cell.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.TableRow
  ): zio.aws.honeycode.model.TableRow.ReadOnly = new Wrapper(impl)
}
