package zio.aws.honeycode.model
import scala.jdk.CollectionConverters.*
sealed trait Format {
  def unwrap: software.amazon.awssdk.services.honeycode.model.Format
}
object Format {
  def wrap(
      value: software.amazon.awssdk.services.honeycode.model.Format
  ): zio.aws.honeycode.model.Format = value match {
    case software.amazon.awssdk.services.honeycode.model.Format.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.honeycode.model.Format.AUTO =>
      val r = AUTO
      r
    case software.amazon.awssdk.services.honeycode.model.Format.NUMBER =>
      val r = NUMBER
      r
    case software.amazon.awssdk.services.honeycode.model.Format.CURRENCY =>
      val r = CURRENCY
      r
    case software.amazon.awssdk.services.honeycode.model.Format.DATE =>
      val r = DATE
      r
    case software.amazon.awssdk.services.honeycode.model.Format.TIME =>
      val r = TIME
      r
    case software.amazon.awssdk.services.honeycode.model.Format.DATE_TIME =>
      val r = DATE_TIME
      r
    case software.amazon.awssdk.services.honeycode.model.Format.PERCENTAGE =>
      val r = PERCENTAGE
      r
    case software.amazon.awssdk.services.honeycode.model.Format.TEXT =>
      val r = TEXT
      r
    case software.amazon.awssdk.services.honeycode.model.Format.ACCOUNTING =>
      val r = ACCOUNTING
      r
    case software.amazon.awssdk.services.honeycode.model.Format.CONTACT =>
      val r = CONTACT
      r
    case software.amazon.awssdk.services.honeycode.model.Format.ROWLINK =>
      val r = ROWLINK
      r
  }
  case object unknownToSdkVersion extends zio.aws.honeycode.model.Format {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.Format =
      software.amazon.awssdk.services.honeycode.model.Format.UNKNOWN_TO_SDK_VERSION
  }
  case object AUTO extends zio.aws.honeycode.model.Format {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.Format =
      software.amazon.awssdk.services.honeycode.model.Format.AUTO
  }
  case object NUMBER extends zio.aws.honeycode.model.Format {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.Format =
      software.amazon.awssdk.services.honeycode.model.Format.NUMBER
  }
  case object CURRENCY extends zio.aws.honeycode.model.Format {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.Format =
      software.amazon.awssdk.services.honeycode.model.Format.CURRENCY
  }
  case object DATE extends zio.aws.honeycode.model.Format {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.Format =
      software.amazon.awssdk.services.honeycode.model.Format.DATE
  }
  case object TIME extends zio.aws.honeycode.model.Format {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.Format =
      software.amazon.awssdk.services.honeycode.model.Format.TIME
  }
  case object DATE_TIME extends zio.aws.honeycode.model.Format {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.Format =
      software.amazon.awssdk.services.honeycode.model.Format.DATE_TIME
  }
  case object PERCENTAGE extends zio.aws.honeycode.model.Format {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.Format =
      software.amazon.awssdk.services.honeycode.model.Format.PERCENTAGE
  }
  case object TEXT extends zio.aws.honeycode.model.Format {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.Format =
      software.amazon.awssdk.services.honeycode.model.Format.TEXT
  }
  case object ACCOUNTING extends zio.aws.honeycode.model.Format {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.Format =
      software.amazon.awssdk.services.honeycode.model.Format.ACCOUNTING
  }
  case object CONTACT extends zio.aws.honeycode.model.Format {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.Format =
      software.amazon.awssdk.services.honeycode.model.Format.CONTACT
  }
  case object ROWLINK extends zio.aws.honeycode.model.Format {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.Format =
      software.amazon.awssdk.services.honeycode.model.Format.ROWLINK
  }
}
