package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.honeycode.model.primitives.{TableName, ResourceId}
import scala.jdk.CollectionConverters.*
final case class Table(
    tableId: Option[ResourceId] = None,
    tableName: Option[TableName] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.honeycode.model.Table = {
    import Table.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.Table
      .builder()
      .optionallyWith(
        tableId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.tableId)
      .optionallyWith(
        tableName.map(value => TableName.unwrap(value): java.lang.String)
      )(_.tableName)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.Table.ReadOnly =
    zio.aws.honeycode.model.Table.wrap(buildAwsValue())
}
object Table {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.honeycode.model.Table] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.Table = zio.aws.honeycode.model
      .Table(tableId.map(value => value), tableName.map(value => value))
    def tableId: Option[ResourceId]
    def tableName: Option[TableName]
    def getTableId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("tableId", tableId)
    def getTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField("tableName", tableName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.Table
  ) extends zio.aws.honeycode.model.Table.ReadOnly {
    override val tableId: Option[ResourceId] = scala
      .Option(impl.tableId())
      .map(value => zio.aws.honeycode.model.primitives.ResourceId(value))
    override val tableName: Option[TableName] = scala
      .Option(impl.tableName())
      .map(value => zio.aws.honeycode.model.primitives.TableName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.Table
  ): zio.aws.honeycode.model.Table.ReadOnly = new Wrapper(impl)
}
