package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.honeycode.model.primitives.ResourceId
import scala.jdk.CollectionConverters.*
final case class DestinationOptions(
    columnMap: Option[
      Map[ResourceId, zio.aws.honeycode.model.SourceDataColumnProperties]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.DestinationOptions = {
    import DestinationOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.DestinationOptions
      .builder()
      .optionallyWith(
        columnMap.map(value =>
          value
            .map({ case (key, value) =>
              (ResourceId.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.columnMap)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.DestinationOptions.ReadOnly =
    zio.aws.honeycode.model.DestinationOptions.wrap(buildAwsValue())
}
object DestinationOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.DestinationOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.DestinationOptions =
      zio.aws.honeycode.model.DestinationOptions(
        columnMap.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def columnMap: Option[Map[
      ResourceId,
      zio.aws.honeycode.model.SourceDataColumnProperties.ReadOnly
    ]]
    def getColumnMap: ZIO[Any, AwsError, Map[
      ResourceId,
      zio.aws.honeycode.model.SourceDataColumnProperties.ReadOnly
    ]] = AwsError.unwrapOptionField("columnMap", columnMap)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.DestinationOptions
  ) extends zio.aws.honeycode.model.DestinationOptions.ReadOnly {
    override val columnMap: Option[Map[
      ResourceId,
      zio.aws.honeycode.model.SourceDataColumnProperties.ReadOnly
    ]] = scala
      .Option(impl.columnMap())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.honeycode.model.primitives.ResourceId(
              key
            ) -> zio.aws.honeycode.model.SourceDataColumnProperties.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.DestinationOptions
  ): zio.aws.honeycode.model.DestinationOptions.ReadOnly = new Wrapper(impl)
}
