package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.honeycode.model.primitives.{TableName, ResourceId}
import scala.jdk.CollectionConverters._
final case class Table(
    tableId: Optional[ResourceId] = Optional.Absent,
    tableName: Optional[TableName] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.honeycode.model.Table = {
    import Table.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.Table
      .builder()
      .optionallyWith(
        tableId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.tableId)
      .optionallyWith(
        tableName.map(value => TableName.unwrap(value): java.lang.String)
      )(_.tableName)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.Table.ReadOnly =
    zio.aws.honeycode.model.Table.wrap(buildAwsValue())
}
object Table {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.honeycode.model.Table] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.Table = zio.aws.honeycode.model
      .Table(tableId.map(value => value), tableName.map(value => value))
    def tableId: Optional[ResourceId]
    def tableName: Optional[TableName]
    def getTableId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("tableId", tableId)
    def getTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField("tableName", tableName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.Table
  ) extends zio.aws.honeycode.model.Table.ReadOnly {
    override val tableId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.tableId())
      .map(value => zio.aws.honeycode.model.primitives.ResourceId(value))
    override val tableName: Optional[TableName] = zio.aws.core.internal
      .optionalFromNullable(impl.tableName())
      .map(value => zio.aws.honeycode.model.primitives.TableName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.Table
  ): zio.aws.honeycode.model.Table.ReadOnly = new Wrapper(impl)
}
