package zio.aws.honeycode.model
import zio.aws.honeycode.model.primitives.SourceDataColumnIndex
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SourceDataColumnProperties(
    columnIndex: Optional[SourceDataColumnIndex] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.SourceDataColumnProperties = {
    import SourceDataColumnProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.SourceDataColumnProperties
      .builder()
      .optionallyWith(
        columnIndex.map(value => SourceDataColumnIndex.unwrap(value): Integer)
      )(_.columnIndex)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.SourceDataColumnProperties.ReadOnly =
    zio.aws.honeycode.model.SourceDataColumnProperties.wrap(buildAwsValue())
}
object SourceDataColumnProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.SourceDataColumnProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.SourceDataColumnProperties =
      zio.aws.honeycode.model
        .SourceDataColumnProperties(columnIndex.map(value => value))
    def columnIndex: Optional[SourceDataColumnIndex]
    def getColumnIndex: ZIO[Any, AwsError, SourceDataColumnIndex] =
      AwsError.unwrapOptionField("columnIndex", columnIndex)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.SourceDataColumnProperties
  ) extends zio.aws.honeycode.model.SourceDataColumnProperties.ReadOnly {
    override val columnIndex: Optional[SourceDataColumnIndex] =
      zio.aws.core.internal
        .optionalFromNullable(impl.columnIndex())
        .map(value =>
          zio.aws.honeycode.model.primitives.SourceDataColumnIndex(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.SourceDataColumnProperties
  ): zio.aws.honeycode.model.SourceDataColumnProperties.ReadOnly = new Wrapper(
    impl
  )
}
