package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ResultSet(
    headers: Iterable[zio.aws.honeycode.model.ColumnMetadata],
    rows: Iterable[zio.aws.honeycode.model.ResultRow]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.ResultSet = {
    import ResultSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.ResultSet
      .builder()
      .headers(headers.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .rows(rows.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.ResultSet.ReadOnly =
    zio.aws.honeycode.model.ResultSet.wrap(buildAwsValue())
}
object ResultSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.ResultSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.ResultSet =
      zio.aws.honeycode.model.ResultSet(
        headers.map { item =>
          item.asEditable
        },
        rows.map { item =>
          item.asEditable
        }
      )
    def headers: List[zio.aws.honeycode.model.ColumnMetadata.ReadOnly]
    def rows: List[zio.aws.honeycode.model.ResultRow.ReadOnly]
    def getHeaders: ZIO[Any, Nothing, List[
      zio.aws.honeycode.model.ColumnMetadata.ReadOnly
    ]] = ZIO.succeed(headers)
    def getRows
        : ZIO[Any, Nothing, List[zio.aws.honeycode.model.ResultRow.ReadOnly]] =
      ZIO.succeed(rows)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.ResultSet
  ) extends zio.aws.honeycode.model.ResultSet.ReadOnly {
    override val headers
        : List[zio.aws.honeycode.model.ColumnMetadata.ReadOnly] = impl
      .headers()
      .asScala
      .map { item =>
        zio.aws.honeycode.model.ColumnMetadata.wrap(item)
      }
      .toList
    override val rows: List[zio.aws.honeycode.model.ResultRow.ReadOnly] = impl
      .rows()
      .asScala
      .map { item =>
        zio.aws.honeycode.model.ResultRow.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.ResultSet
  ): zio.aws.honeycode.model.ResultSet.ReadOnly = new Wrapper(impl)
}
