package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.honeycode.model.primitives.{ResourceId, RowId}
import scala.jdk.CollectionConverters._
final case class UpdateRowData(
    rowId: RowId,
    cellsToUpdate: Map[ResourceId, zio.aws.honeycode.model.CellInput]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.UpdateRowData = {
    import UpdateRowData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.UpdateRowData
      .builder()
      .rowId(RowId.unwrap(rowId): java.lang.String)
      .cellsToUpdate(
        cellsToUpdate
          .map({ case (key, value) =>
            (ResourceId.unwrap(key): java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.UpdateRowData.ReadOnly =
    zio.aws.honeycode.model.UpdateRowData.wrap(buildAwsValue())
}
object UpdateRowData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.UpdateRowData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.UpdateRowData =
      zio.aws.honeycode.model.UpdateRowData(
        rowId,
        cellsToUpdate.map({ case (key, value) =>
          key -> value.asEditable
        })
      )
    def rowId: RowId
    def cellsToUpdate
        : Map[ResourceId, zio.aws.honeycode.model.CellInput.ReadOnly]
    def getRowId: ZIO[Any, Nothing, RowId] = ZIO.succeed(rowId)
    def getCellsToUpdate: ZIO[Any, Nothing, Map[
      ResourceId,
      zio.aws.honeycode.model.CellInput.ReadOnly
    ]] = ZIO.succeed(cellsToUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.UpdateRowData
  ) extends zio.aws.honeycode.model.UpdateRowData.ReadOnly {
    override val rowId: RowId =
      zio.aws.honeycode.model.primitives.RowId(impl.rowId())
    override val cellsToUpdate
        : Map[ResourceId, zio.aws.honeycode.model.CellInput.ReadOnly] = impl
      .cellsToUpdate()
      .asScala
      .map({ case (key, value) =>
        zio.aws.honeycode.model.primitives
          .ResourceId(key) -> zio.aws.honeycode.model.CellInput.wrap(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.UpdateRowData
  ): zio.aws.honeycode.model.UpdateRowData.ReadOnly = new Wrapper(impl)
}
