package zio.aws.honeycode.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.honeycode.model.primitives.SourceDataColumnIndex
import scala.jdk.CollectionConverters._
final case class SourceDataColumnProperties(
    columnIndex: Option[SourceDataColumnIndex] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.SourceDataColumnProperties = {
    import SourceDataColumnProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.SourceDataColumnProperties
      .builder()
      .optionallyWith(
        columnIndex.map(value => SourceDataColumnIndex.unwrap(value): Integer)
      )(_.columnIndex)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.SourceDataColumnProperties.ReadOnly =
    zio.aws.honeycode.model.SourceDataColumnProperties.wrap(buildAwsValue())
}
object SourceDataColumnProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.SourceDataColumnProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.SourceDataColumnProperties =
      zio.aws.honeycode.model
        .SourceDataColumnProperties(columnIndex.map(value => value))
    def columnIndex: Option[SourceDataColumnIndex]
    def getColumnIndex: ZIO[Any, AwsError, SourceDataColumnIndex] =
      AwsError.unwrapOptionField("columnIndex", columnIndex)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.SourceDataColumnProperties
  ) extends zio.aws.honeycode.model.SourceDataColumnProperties.ReadOnly {
    override val columnIndex: Option[SourceDataColumnIndex] = scala
      .Option(impl.columnIndex())
      .map(value =>
        zio.aws.honeycode.model.primitives.SourceDataColumnIndex(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.SourceDataColumnProperties
  ): zio.aws.honeycode.model.SourceDataColumnProperties.ReadOnly = new Wrapper(
    impl
  )
}
