package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.honeycode.model.primitives.{FormattedValue, RawValue, Formula}
import scala.jdk.CollectionConverters._
final case class Cell(
    formula: Option[Formula] = None,
    format: Option[zio.aws.honeycode.model.Format] = None,
    rawValue: Option[RawValue] = None,
    formattedValue: Option[FormattedValue] = None,
    formattedValues: Option[Iterable[FormattedValue]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.honeycode.model.Cell = {
    import Cell.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.Cell
      .builder()
      .optionallyWith(
        formula.map(value => Formula.unwrap(value): java.lang.String)
      )(_.formula)
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .optionallyWith(
        rawValue.map(value => RawValue.unwrap(value): java.lang.String)
      )(_.rawValue)
      .optionallyWith(
        formattedValue.map(value =>
          FormattedValue.unwrap(value): java.lang.String
        )
      )(_.formattedValue)
      .optionallyWith(
        formattedValues.map(value =>
          value.map { item =>
            FormattedValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.formattedValues)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.Cell.ReadOnly =
    zio.aws.honeycode.model.Cell.wrap(buildAwsValue())
}
object Cell {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.honeycode.model.Cell] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.Cell = zio.aws.honeycode.model.Cell(
      formula.map(value => value),
      format.map(value => value),
      rawValue.map(value => value),
      formattedValue.map(value => value),
      formattedValues.map(value => value)
    )
    def formula: Option[Formula]
    def format: Option[zio.aws.honeycode.model.Format]
    def rawValue: Option[RawValue]
    def formattedValue: Option[FormattedValue]
    def formattedValues: Option[List[FormattedValue]]
    def getFormula: ZIO[Any, AwsError, Formula] =
      AwsError.unwrapOptionField("formula", formula)
    def getFormat: ZIO[Any, AwsError, zio.aws.honeycode.model.Format] =
      AwsError.unwrapOptionField("format", format)
    def getRawValue: ZIO[Any, AwsError, RawValue] =
      AwsError.unwrapOptionField("rawValue", rawValue)
    def getFormattedValue: ZIO[Any, AwsError, FormattedValue] =
      AwsError.unwrapOptionField("formattedValue", formattedValue)
    def getFormattedValues: ZIO[Any, AwsError, List[FormattedValue]] =
      AwsError.unwrapOptionField("formattedValues", formattedValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.Cell
  ) extends zio.aws.honeycode.model.Cell.ReadOnly {
    override val formula: Option[Formula] = scala
      .Option(impl.formula())
      .map(value => zio.aws.honeycode.model.primitives.Formula(value))
    override val format: Option[zio.aws.honeycode.model.Format] = scala
      .Option(impl.format())
      .map(value => zio.aws.honeycode.model.Format.wrap(value))
    override val rawValue: Option[RawValue] = scala
      .Option(impl.rawValue())
      .map(value => zio.aws.honeycode.model.primitives.RawValue(value))
    override val formattedValue: Option[FormattedValue] = scala
      .Option(impl.formattedValue())
      .map(value => zio.aws.honeycode.model.primitives.FormattedValue(value))
    override val formattedValues: Option[List[FormattedValue]] = scala
      .Option(impl.formattedValues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.honeycode.model.primitives.FormattedValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.Cell
  ): zio.aws.honeycode.model.Cell.ReadOnly = new Wrapper(impl)
}
