package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.honeycode.model.primitives.SecureURL
import scala.jdk.CollectionConverters._
final case class ImportDataSourceConfig(
    dataSourceUrl: Option[SecureURL] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.ImportDataSourceConfig = {
    import ImportDataSourceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.ImportDataSourceConfig
      .builder()
      .optionallyWith(
        dataSourceUrl.map(value => SecureURL.unwrap(value): java.lang.String)
      )(_.dataSourceUrl)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.ImportDataSourceConfig.ReadOnly =
    zio.aws.honeycode.model.ImportDataSourceConfig.wrap(buildAwsValue())
}
object ImportDataSourceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.ImportDataSourceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.ImportDataSourceConfig =
      zio.aws.honeycode.model
        .ImportDataSourceConfig(dataSourceUrl.map(value => value))
    def dataSourceUrl: Option[SecureURL]
    def getDataSourceUrl: ZIO[Any, AwsError, SecureURL] =
      AwsError.unwrapOptionField("dataSourceUrl", dataSourceUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.ImportDataSourceConfig
  ) extends zio.aws.honeycode.model.ImportDataSourceConfig.ReadOnly {
    override val dataSourceUrl: Option[SecureURL] = scala
      .Option(impl.dataSourceUrl())
      .map(value => zio.aws.honeycode.model.primitives.SecureURL(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.ImportDataSourceConfig
  ): zio.aws.honeycode.model.ImportDataSourceConfig.ReadOnly = new Wrapper(impl)
}
