package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.honeycode.model.primitives.RawValue
import scala.jdk.CollectionConverters._
final case class VariableValue(rawValue: RawValue) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.VariableValue = {
    import VariableValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.VariableValue
      .builder()
      .rawValue(RawValue.unwrap(rawValue): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.VariableValue.ReadOnly =
    zio.aws.honeycode.model.VariableValue.wrap(buildAwsValue())
}
object VariableValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.VariableValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.VariableValue =
      zio.aws.honeycode.model.VariableValue(rawValue)
    def rawValue: RawValue
    def getRawValue: ZIO[Any, Nothing, RawValue] = ZIO.succeed(rawValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.VariableValue
  ) extends zio.aws.honeycode.model.VariableValue.ReadOnly {
    override val rawValue: RawValue =
      zio.aws.honeycode.model.primitives.RawValue(impl.rawValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.VariableValue
  ): zio.aws.honeycode.model.VariableValue.ReadOnly = new Wrapper(impl)
}
