package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.honeycode.model.primitives.{FormattedValue, RawValue}
import scala.jdk.CollectionConverters._
final case class DataItem(
    overrideFormat: Option[zio.aws.honeycode.model.Format] = None,
    rawValue: Option[RawValue] = None,
    formattedValue: Option[FormattedValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.DataItem = {
    import DataItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.DataItem
      .builder()
      .optionallyWith(overrideFormat.map(value => value.unwrap))(
        _.overrideFormat
      )
      .optionallyWith(
        rawValue.map(value => RawValue.unwrap(value): java.lang.String)
      )(_.rawValue)
      .optionallyWith(
        formattedValue.map(value =>
          FormattedValue.unwrap(value): java.lang.String
        )
      )(_.formattedValue)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.DataItem.ReadOnly =
    zio.aws.honeycode.model.DataItem.wrap(buildAwsValue())
}
object DataItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.DataItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.DataItem =
      zio.aws.honeycode.model.DataItem(
        overrideFormat.map(value => value),
        rawValue.map(value => value),
        formattedValue.map(value => value)
      )
    def overrideFormat: Option[zio.aws.honeycode.model.Format]
    def rawValue: Option[RawValue]
    def formattedValue: Option[FormattedValue]
    def getOverrideFormat: ZIO[Any, AwsError, zio.aws.honeycode.model.Format] =
      AwsError.unwrapOptionField("overrideFormat", overrideFormat)
    def getRawValue: ZIO[Any, AwsError, RawValue] =
      AwsError.unwrapOptionField("rawValue", rawValue)
    def getFormattedValue: ZIO[Any, AwsError, FormattedValue] =
      AwsError.unwrapOptionField("formattedValue", formattedValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.DataItem
  ) extends zio.aws.honeycode.model.DataItem.ReadOnly {
    override val overrideFormat: Option[zio.aws.honeycode.model.Format] = scala
      .Option(impl.overrideFormat())
      .map(value => zio.aws.honeycode.model.Format.wrap(value))
    override val rawValue: Option[RawValue] = scala
      .Option(impl.rawValue())
      .map(value => zio.aws.honeycode.model.primitives.RawValue(value))
    override val formattedValue: Option[FormattedValue] = scala
      .Option(impl.formattedValue())
      .map(value => zio.aws.honeycode.model.primitives.FormattedValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.DataItem
  ): zio.aws.honeycode.model.DataItem.ReadOnly = new Wrapper(impl)
}
