package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.honeycode.model.primitives.{ClientRequestToken, ResourceId}
import scala.jdk.CollectionConverters._
final case class StartTableDataImportJobRequest(
    workbookId: ResourceId,
    dataSource: zio.aws.honeycode.model.ImportDataSource,
    dataFormat: zio.aws.honeycode.model.ImportSourceDataFormat,
    destinationTableId: ResourceId,
    importOptions: zio.aws.honeycode.model.ImportOptions,
    clientRequestToken: ClientRequestToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.StartTableDataImportJobRequest = {
    import StartTableDataImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.StartTableDataImportJobRequest
      .builder()
      .workbookId(ResourceId.unwrap(workbookId): java.lang.String)
      .dataSource(dataSource.buildAwsValue())
      .dataFormat(dataFormat.unwrap)
      .destinationTableId(
        ResourceId.unwrap(destinationTableId): java.lang.String
      )
      .importOptions(importOptions.buildAwsValue())
      .clientRequestToken(
        ClientRequestToken.unwrap(clientRequestToken): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.honeycode.model.StartTableDataImportJobRequest.ReadOnly =
    zio.aws.honeycode.model.StartTableDataImportJobRequest.wrap(buildAwsValue())
}
object StartTableDataImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.StartTableDataImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.StartTableDataImportJobRequest =
      zio.aws.honeycode.model.StartTableDataImportJobRequest(
        workbookId,
        dataSource.asEditable,
        dataFormat,
        destinationTableId,
        importOptions.asEditable,
        clientRequestToken
      )
    def workbookId: ResourceId
    def dataSource: zio.aws.honeycode.model.ImportDataSource.ReadOnly
    def dataFormat: zio.aws.honeycode.model.ImportSourceDataFormat
    def destinationTableId: ResourceId
    def importOptions: zio.aws.honeycode.model.ImportOptions.ReadOnly
    def clientRequestToken: ClientRequestToken
    def getWorkbookId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(workbookId)
    def getDataSource
        : ZIO[Any, Nothing, zio.aws.honeycode.model.ImportDataSource.ReadOnly] =
      ZIO.succeed(dataSource)
    def getDataFormat
        : ZIO[Any, Nothing, zio.aws.honeycode.model.ImportSourceDataFormat] =
      ZIO.succeed(dataFormat)
    def getDestinationTableId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(destinationTableId)
    def getImportOptions
        : ZIO[Any, Nothing, zio.aws.honeycode.model.ImportOptions.ReadOnly] =
      ZIO.succeed(importOptions)
    def getClientRequestToken: ZIO[Any, Nothing, ClientRequestToken] =
      ZIO.succeed(clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.StartTableDataImportJobRequest
  ) extends zio.aws.honeycode.model.StartTableDataImportJobRequest.ReadOnly {
    override val workbookId: ResourceId =
      zio.aws.honeycode.model.primitives.ResourceId(impl.workbookId())
    override val dataSource: zio.aws.honeycode.model.ImportDataSource.ReadOnly =
      zio.aws.honeycode.model.ImportDataSource.wrap(impl.dataSource())
    override val dataFormat: zio.aws.honeycode.model.ImportSourceDataFormat =
      zio.aws.honeycode.model.ImportSourceDataFormat.wrap(impl.dataFormat())
    override val destinationTableId: ResourceId =
      zio.aws.honeycode.model.primitives.ResourceId(impl.destinationTableId())
    override val importOptions: zio.aws.honeycode.model.ImportOptions.ReadOnly =
      zio.aws.honeycode.model.ImportOptions.wrap(impl.importOptions())
    override val clientRequestToken: ClientRequestToken =
      zio.aws.honeycode.model.primitives
        .ClientRequestToken(impl.clientRequestToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.StartTableDataImportJobRequest
  ): zio.aws.honeycode.model.StartTableDataImportJobRequest.ReadOnly =
    new Wrapper(impl)
}
