package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.honeycode.model.primitives.{RowId, Formula}
import scala.jdk.CollectionConverters._
final case class Filter(
    formula: Formula,
    contextRowId: Optional[RowId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.Filter = {
    import Filter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.Filter
      .builder()
      .formula(Formula.unwrap(formula): java.lang.String)
      .optionallyWith(
        contextRowId.map(value => RowId.unwrap(value): java.lang.String)
      )(_.contextRowId)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.Filter.ReadOnly =
    zio.aws.honeycode.model.Filter.wrap(buildAwsValue())
}
object Filter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.honeycode.model.Filter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.Filter =
      zio.aws.honeycode.model.Filter(formula, contextRowId.map(value => value))
    def formula: Formula
    def contextRowId: Optional[RowId]
    def getFormula: ZIO[Any, Nothing, Formula] = ZIO.succeed(formula)
    def getContextRowId: ZIO[Any, AwsError, RowId] =
      AwsError.unwrapOptionField("contextRowId", contextRowId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.Filter
  ) extends zio.aws.honeycode.model.Filter.ReadOnly {
    override val formula: Formula =
      zio.aws.honeycode.model.primitives.Formula(impl.formula())
    override val contextRowId: Optional[RowId] = zio.aws.core.internal
      .optionalFromNullable(impl.contextRowId())
      .map(value => zio.aws.honeycode.model.primitives.RowId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.Filter
  ): zio.aws.honeycode.model.Filter.ReadOnly = new Wrapper(impl)
}
