package zio.aws.honeycode.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.honeycode.model.primitives.{
  PaginationToken,
  MaxResults,
  VariableName,
  ResourceId
}
import scala.jdk.CollectionConverters._
final case class GetScreenDataRequest(
    workbookId: ResourceId,
    appId: ResourceId,
    screenId: ResourceId,
    variables: Option[
      Map[VariableName, zio.aws.honeycode.model.VariableValue]
    ] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.GetScreenDataRequest = {
    import GetScreenDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.GetScreenDataRequest
      .builder()
      .workbookId(ResourceId.unwrap(workbookId): java.lang.String)
      .appId(ResourceId.unwrap(appId): java.lang.String)
      .screenId(ResourceId.unwrap(screenId): java.lang.String)
      .optionallyWith(
        variables.map(value =>
          value
            .map({ case (key, value) =>
              (VariableName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.variables)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.GetScreenDataRequest.ReadOnly =
    zio.aws.honeycode.model.GetScreenDataRequest.wrap(buildAwsValue())
}
object GetScreenDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.GetScreenDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.GetScreenDataRequest =
      zio.aws.honeycode.model.GetScreenDataRequest(
        workbookId,
        appId,
        screenId,
        variables.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def workbookId: ResourceId
    def appId: ResourceId
    def screenId: ResourceId
    def variables: Option[
      Map[VariableName, zio.aws.honeycode.model.VariableValue.ReadOnly]
    ]
    def maxResults: Option[MaxResults]
    def nextToken: Option[PaginationToken]
    def getWorkbookId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(workbookId)
    def getAppId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(appId)
    def getScreenId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(screenId)
    def getVariables: ZIO[Any, AwsError, Map[
      VariableName,
      zio.aws.honeycode.model.VariableValue.ReadOnly
    ]] = AwsError.unwrapOptionField("variables", variables)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.GetScreenDataRequest
  ) extends zio.aws.honeycode.model.GetScreenDataRequest.ReadOnly {
    override val workbookId: ResourceId =
      zio.aws.honeycode.model.primitives.ResourceId(impl.workbookId())
    override val appId: ResourceId =
      zio.aws.honeycode.model.primitives.ResourceId(impl.appId())
    override val screenId: ResourceId =
      zio.aws.honeycode.model.primitives.ResourceId(impl.screenId())
    override val variables: Option[
      Map[VariableName, zio.aws.honeycode.model.VariableValue.ReadOnly]
    ] = scala
      .Option(impl.variables())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.honeycode.model.primitives.VariableName(
              key
            ) -> zio.aws.honeycode.model.VariableValue.wrap(value)
          })
          .toMap
      )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.honeycode.model.primitives.MaxResults(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.honeycode.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.GetScreenDataRequest
  ): zio.aws.honeycode.model.GetScreenDataRequest.ReadOnly = new Wrapper(impl)
}
