package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.honeycode.model.primitives.Fact
import scala.jdk.CollectionConverters._
final case class CellInput(fact: Option[Fact] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.CellInput = {
    import CellInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.CellInput
      .builder()
      .optionallyWith(fact.map(value => Fact.unwrap(value): java.lang.String))(
        _.fact
      )
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.CellInput.ReadOnly =
    zio.aws.honeycode.model.CellInput.wrap(buildAwsValue())
}
object CellInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.CellInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.CellInput =
      zio.aws.honeycode.model.CellInput(fact.map(value => value))
    def fact: Option[Fact]
    def getFact: ZIO[Any, AwsError, Fact] =
      AwsError.unwrapOptionField("fact", fact)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.CellInput
  ) extends zio.aws.honeycode.model.CellInput.ReadOnly {
    override val fact: Option[Fact] = scala
      .Option(impl.fact())
      .map(value => zio.aws.honeycode.model.primitives.Fact(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.CellInput
  ): zio.aws.honeycode.model.CellInput.ReadOnly = new Wrapper(impl)
}
