/*
 * Decompiled with CFR 0.152.
 */
package zio.aws.groundstation.model;

import java.io.Serializable;
import scala.Function1;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import software.amazon.awssdk.utils.builder.SdkBuilder;
import zio.ZIO;
import zio.ZIO$;
import zio.aws.core.AwsError;
import zio.aws.core.AwsError$;
import zio.aws.core.internal.package$;
import zio.aws.groundstation.model.Frequency;
import zio.aws.groundstation.model.Frequency$;
import zio.aws.groundstation.model.FrequencyBandwidth;
import zio.aws.groundstation.model.FrequencyBandwidth$;
import zio.aws.groundstation.model.Polarization;
import zio.aws.groundstation.model.Polarization$;
import zio.aws.groundstation.model.SpectrumConfig$;
import zio.prelude.data.Optional;

public final class SpectrumConfig
implements Product,
Serializable {
    private final FrequencyBandwidth bandwidth;
    private final Frequency centerFrequency;
    private final Optional polarization;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(SpectrumConfig$.class.getDeclaredField("zioAwsBuilderHelper$lzy1"));

    public static SpectrumConfig apply(FrequencyBandwidth frequencyBandwidth, Frequency frequency, Optional<Polarization> optional) {
        return SpectrumConfig$.MODULE$.apply(frequencyBandwidth, frequency, optional);
    }

    public static SpectrumConfig fromProduct(Product product) {
        return SpectrumConfig$.MODULE$.fromProduct(product);
    }

    public static SpectrumConfig unapply(SpectrumConfig spectrumConfig) {
        return SpectrumConfig$.MODULE$.unapply(spectrumConfig);
    }

    public static ReadOnly wrap(software.amazon.awssdk.services.groundstation.model.SpectrumConfig spectrumConfig) {
        return SpectrumConfig$.MODULE$.wrap(spectrumConfig);
    }

    public static Optional<Polarization> $lessinit$greater$default$3() {
        return SpectrumConfig$.MODULE$.$lessinit$greater$default$3();
    }

    public SpectrumConfig(FrequencyBandwidth bandwidth, Frequency centerFrequency, Optional<Polarization> polarization) {
        this.bandwidth = bandwidth;
        this.centerFrequency = centerFrequency;
        this.polarization = polarization;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof SpectrumConfig)) return false;
        SpectrumConfig spectrumConfig = (SpectrumConfig)object;
        FrequencyBandwidth frequencyBandwidth = this.bandwidth();
        FrequencyBandwidth frequencyBandwidth2 = spectrumConfig.bandwidth();
        if (frequencyBandwidth == null) {
            if (frequencyBandwidth2 != null) {
                return false;
            }
        } else if (!((Object)frequencyBandwidth).equals(frequencyBandwidth2)) return false;
        Frequency frequency = this.centerFrequency();
        Frequency frequency2 = spectrumConfig.centerFrequency();
        if (frequency == null) {
            if (frequency2 != null) {
                return false;
            }
        } else if (!((Object)frequency).equals(frequency2)) return false;
        Optional<Polarization> optional = this.polarization();
        Optional<Polarization> optional2 = spectrumConfig.polarization();
        if (optional == null) {
            if (optional2 == null) return true;
            return false;
        } else {
            if (!optional.equals(optional2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof SpectrumConfig;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "SpectrumConfig";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "bandwidth";
            }
            case 1: {
                return "centerFrequency";
            }
            case 2: {
                return "polarization";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public FrequencyBandwidth bandwidth() {
        return this.bandwidth;
    }

    public Frequency centerFrequency() {
        return this.centerFrequency;
    }

    public Optional<Polarization> polarization() {
        return this.polarization;
    }

    public software.amazon.awssdk.services.groundstation.model.SpectrumConfig buildAwsValue() {
        return (software.amazon.awssdk.services.groundstation.model.SpectrumConfig)SpectrumConfig$.MODULE$.zio$aws$groundstation$model$SpectrumConfig$$$zioAwsBuilderHelper().BuilderOps((SdkBuilder)software.amazon.awssdk.services.groundstation.model.SpectrumConfig.builder().bandwidth(this.bandwidth().buildAwsValue()).centerFrequency(this.centerFrequency().buildAwsValue())).optionallyWith(this.polarization().map((Function1 & Serializable)value -> value.unwrap()), (Function1 & Serializable)_$1 -> (Function1 & Serializable)x$0 -> _$1.polarization(x$0)).build();
    }

    public ReadOnly asReadOnly() {
        return SpectrumConfig$.MODULE$.wrap(this.buildAwsValue());
    }

    public SpectrumConfig copy(FrequencyBandwidth bandwidth, Frequency centerFrequency, Optional<Polarization> polarization) {
        return new SpectrumConfig(bandwidth, centerFrequency, polarization);
    }

    public FrequencyBandwidth copy$default$1() {
        return this.bandwidth();
    }

    public Frequency copy$default$2() {
        return this.centerFrequency();
    }

    public Optional<Polarization> copy$default$3() {
        return this.polarization();
    }

    public FrequencyBandwidth _1() {
        return this.bandwidth();
    }

    public Frequency _2() {
        return this.centerFrequency();
    }

    public Optional<Polarization> _3() {
        return this.polarization();
    }

    public static interface ReadOnly {
        public static SpectrumConfig asEditable$(ReadOnly $this) {
            return $this.asEditable();
        }

        default public SpectrumConfig asEditable() {
            return SpectrumConfig$.MODULE$.apply(this.bandwidth().asEditable(), this.centerFrequency().asEditable(), (Optional<Polarization>)this.polarization().map((Function1 & Serializable)value -> value));
        }

        public FrequencyBandwidth.ReadOnly bandwidth();

        public Frequency.ReadOnly centerFrequency();

        public Optional<Polarization> polarization();

        public static ZIO getBandwidth$(ReadOnly $this) {
            return $this.getBandwidth();
        }

        default public ZIO<Object, Nothing$, FrequencyBandwidth.ReadOnly> getBandwidth() {
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$1 -> this.bandwidth(), (Object)"zio.aws.groundstation.model.SpectrumConfig.ReadOnly.getBandwidth(SpectrumConfig.scala:43)");
        }

        public static ZIO getCenterFrequency$(ReadOnly $this) {
            return $this.getCenterFrequency();
        }

        default public ZIO<Object, Nothing$, Frequency.ReadOnly> getCenterFrequency() {
            return ZIO$.MODULE$.succeed((Function1 & Serializable)evidence$2 -> this.centerFrequency(), (Object)"zio.aws.groundstation.model.SpectrumConfig.ReadOnly.getCenterFrequency(SpectrumConfig.scala:46)");
        }

        public static ZIO getPolarization$(ReadOnly $this) {
            return $this.getPolarization();
        }

        default public ZIO<Object, AwsError, Polarization> getPolarization() {
            return AwsError$.MODULE$.unwrapOptionField("polarization", this::getPolarization$$anonfun$1);
        }

        private Optional getPolarization$$anonfun$1() {
            return this.polarization();
        }
    }

    public static final class Wrapper
    implements ReadOnly {
        private final FrequencyBandwidth.ReadOnly bandwidth;
        private final Frequency.ReadOnly centerFrequency;
        private final Optional polarization;

        public Wrapper(software.amazon.awssdk.services.groundstation.model.SpectrumConfig impl) {
            this.bandwidth = FrequencyBandwidth$.MODULE$.wrap(impl.bandwidth());
            this.centerFrequency = Frequency$.MODULE$.wrap(impl.centerFrequency());
            this.polarization = package$.MODULE$.optionalFromNullable((Object)impl.polarization()).map((Function1 & Serializable)value -> Polarization$.MODULE$.wrap((software.amazon.awssdk.services.groundstation.model.Polarization)value));
        }

        @Override
        public FrequencyBandwidth.ReadOnly bandwidth() {
            return this.bandwidth;
        }

        @Override
        public Frequency.ReadOnly centerFrequency() {
            return this.centerFrequency;
        }

        @Override
        public Optional<Polarization> polarization() {
            return this.polarization;
        }
    }
}

