package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.Uuid
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateAgentStatusRequest(
    agentId: Uuid,
    aggregateStatus: zio.aws.groundstation.model.AggregateStatus,
    componentStatuses: Iterable[
      zio.aws.groundstation.model.ComponentStatusData
    ],
    taskId: Uuid
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.UpdateAgentStatusRequest = {
    import UpdateAgentStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.UpdateAgentStatusRequest
      .builder()
      .agentId(Uuid.unwrap(agentId): java.lang.String)
      .aggregateStatus(aggregateStatus.buildAwsValue())
      .componentStatuses(componentStatuses.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .taskId(Uuid.unwrap(taskId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.UpdateAgentStatusRequest.ReadOnly =
    zio.aws.groundstation.model.UpdateAgentStatusRequest.wrap(buildAwsValue())
}
object UpdateAgentStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.UpdateAgentStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.UpdateAgentStatusRequest =
      zio.aws.groundstation.model.UpdateAgentStatusRequest(
        agentId,
        aggregateStatus.asEditable,
        componentStatuses.map { item =>
          item.asEditable
        },
        taskId
      )
    def agentId: Uuid
    def aggregateStatus: zio.aws.groundstation.model.AggregateStatus.ReadOnly
    def componentStatuses
        : List[zio.aws.groundstation.model.ComponentStatusData.ReadOnly]
    def taskId: Uuid
    def getAgentId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(agentId)
    def getAggregateStatus: ZIO[
      Any,
      Nothing,
      zio.aws.groundstation.model.AggregateStatus.ReadOnly
    ] = ZIO.succeed(aggregateStatus)
    def getComponentStatuses: ZIO[Any, Nothing, List[
      zio.aws.groundstation.model.ComponentStatusData.ReadOnly
    ]] = ZIO.succeed(componentStatuses)
    def getTaskId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(taskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.UpdateAgentStatusRequest
  ) extends zio.aws.groundstation.model.UpdateAgentStatusRequest.ReadOnly {
    override val agentId: Uuid =
      zio.aws.groundstation.model.primitives.Uuid(impl.agentId())
    override val aggregateStatus
        : zio.aws.groundstation.model.AggregateStatus.ReadOnly =
      zio.aws.groundstation.model.AggregateStatus.wrap(impl.aggregateStatus())
    override val componentStatuses
        : List[zio.aws.groundstation.model.ComponentStatusData.ReadOnly] = impl
      .componentStatuses()
      .asScala
      .map { item =>
        zio.aws.groundstation.model.ComponentStatusData.wrap(item)
      }
      .toList
    override val taskId: Uuid =
      zio.aws.groundstation.model.primitives.Uuid(impl.taskId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.UpdateAgentStatusRequest
  ): zio.aws.groundstation.model.UpdateAgentStatusRequest.ReadOnly =
    new Wrapper(impl)
}
