package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RegisterAgentRequest(
    agentDetails: zio.aws.groundstation.model.AgentDetails,
    discoveryData: zio.aws.groundstation.model.DiscoveryData
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.RegisterAgentRequest = {
    import RegisterAgentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.RegisterAgentRequest
      .builder()
      .agentDetails(agentDetails.buildAwsValue())
      .discoveryData(discoveryData.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.RegisterAgentRequest.ReadOnly =
    zio.aws.groundstation.model.RegisterAgentRequest.wrap(buildAwsValue())
}
object RegisterAgentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.RegisterAgentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.RegisterAgentRequest =
      zio.aws.groundstation.model
        .RegisterAgentRequest(agentDetails.asEditable, discoveryData.asEditable)
    def agentDetails: zio.aws.groundstation.model.AgentDetails.ReadOnly
    def discoveryData: zio.aws.groundstation.model.DiscoveryData.ReadOnly
    def getAgentDetails
        : ZIO[Any, Nothing, zio.aws.groundstation.model.AgentDetails.ReadOnly] =
      ZIO.succeed(agentDetails)
    def getDiscoveryData: ZIO[
      Any,
      Nothing,
      zio.aws.groundstation.model.DiscoveryData.ReadOnly
    ] = ZIO.succeed(discoveryData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.RegisterAgentRequest
  ) extends zio.aws.groundstation.model.RegisterAgentRequest.ReadOnly {
    override val agentDetails
        : zio.aws.groundstation.model.AgentDetails.ReadOnly =
      zio.aws.groundstation.model.AgentDetails.wrap(impl.agentDetails())
    override val discoveryData
        : zio.aws.groundstation.model.DiscoveryData.ReadOnly =
      zio.aws.groundstation.model.DiscoveryData.wrap(impl.discoveryData())
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.RegisterAgentRequest
  ): zio.aws.groundstation.model.RegisterAgentRequest.ReadOnly = new Wrapper(
    impl
  )
}
