package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class IntegerRange(maximum: Integer, minimum: Integer) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.IntegerRange = {
    import IntegerRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.IntegerRange
      .builder()
      .maximum(maximum: java.lang.Integer)
      .minimum(minimum: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.IntegerRange.ReadOnly =
    zio.aws.groundstation.model.IntegerRange.wrap(buildAwsValue())
}
object IntegerRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.IntegerRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.IntegerRange =
      zio.aws.groundstation.model.IntegerRange(maximum, minimum)
    def maximum: Integer
    def minimum: Integer
    def getMaximum: ZIO[Any, Nothing, Integer] = ZIO.succeed(maximum)
    def getMinimum: ZIO[Any, Nothing, Integer] = ZIO.succeed(minimum)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.IntegerRange
  ) extends zio.aws.groundstation.model.IntegerRange.ReadOnly {
    override val maximum: Integer = impl.maximum(): Integer
    override val minimum: Integer = impl.minimum(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.IntegerRange
  ): zio.aws.groundstation.model.IntegerRange.ReadOnly = new Wrapper(impl)
}
