package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.{AWSRegion, GroundStationName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GroundStationData(
    groundStationId: Optional[GroundStationName] = Optional.Absent,
    groundStationName: Optional[GroundStationName] = Optional.Absent,
    region: Optional[AWSRegion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.GroundStationData = {
    import GroundStationData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.GroundStationData
      .builder()
      .optionallyWith(
        groundStationId.map(value =>
          GroundStationName.unwrap(value): java.lang.String
        )
      )(_.groundStationId)
      .optionallyWith(
        groundStationName.map(value =>
          GroundStationName.unwrap(value): java.lang.String
        )
      )(_.groundStationName)
      .optionallyWith(
        region.map(value => AWSRegion.unwrap(value): java.lang.String)
      )(_.region)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.GroundStationData.ReadOnly =
    zio.aws.groundstation.model.GroundStationData.wrap(buildAwsValue())
}
object GroundStationData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.GroundStationData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.GroundStationData =
      zio.aws.groundstation.model.GroundStationData(
        groundStationId.map(value => value),
        groundStationName.map(value => value),
        region.map(value => value)
      )
    def groundStationId: Optional[GroundStationName]
    def groundStationName: Optional[GroundStationName]
    def region: Optional[AWSRegion]
    def getGroundStationId: ZIO[Any, AwsError, GroundStationName] =
      AwsError.unwrapOptionField("groundStationId", groundStationId)
    def getGroundStationName: ZIO[Any, AwsError, GroundStationName] =
      AwsError.unwrapOptionField("groundStationName", groundStationName)
    def getRegion: ZIO[Any, AwsError, AWSRegion] =
      AwsError.unwrapOptionField("region", region)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.GroundStationData
  ) extends zio.aws.groundstation.model.GroundStationData.ReadOnly {
    override val groundStationId: Optional[GroundStationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groundStationId())
        .map(value =>
          zio.aws.groundstation.model.primitives.GroundStationName(value)
        )
    override val groundStationName: Optional[GroundStationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groundStationName())
        .map(value =>
          zio.aws.groundstation.model.primitives.GroundStationName(value)
        )
    override val region: Optional[AWSRegion] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.groundstation.model.primitives.AWSRegion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.GroundStationData
  ): zio.aws.groundstation.model.GroundStationData.ReadOnly = new Wrapper(impl)
}
