package zio.aws.groundstation.model
import java.lang.Integer
import zio.aws.groundstation.model.primitives.{Year, Month}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetMinuteUsageRequest(month: Month, year: Year) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.GetMinuteUsageRequest = {
    import GetMinuteUsageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.GetMinuteUsageRequest
      .builder()
      .month(Month.unwrap(month): Integer)
      .year(Year.unwrap(year): Integer)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.GetMinuteUsageRequest.ReadOnly =
    zio.aws.groundstation.model.GetMinuteUsageRequest.wrap(buildAwsValue())
}
object GetMinuteUsageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.GetMinuteUsageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.GetMinuteUsageRequest =
      zio.aws.groundstation.model.GetMinuteUsageRequest(month, year)
    def month: Month
    def year: Year
    def getMonth: ZIO[Any, Nothing, Month] = ZIO.succeed(month)
    def getYear: ZIO[Any, Nothing, Year] = ZIO.succeed(year)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.GetMinuteUsageRequest
  ) extends zio.aws.groundstation.model.GetMinuteUsageRequest.ReadOnly {
    override val month: Month =
      zio.aws.groundstation.model.primitives.Month(impl.month())
    override val year: Year =
      zio.aws.groundstation.model.primitives.Year(impl.year())
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.GetMinuteUsageRequest
  ): zio.aws.groundstation.model.GetMinuteUsageRequest.ReadOnly = new Wrapper(
    impl
  )
}
