package zio.aws.groundstation.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.groundstation.model.primitives.{
  Uuid,
  DataflowEndpointGroupArn,
  DataflowEndpointGroupDurationInSeconds
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetDataflowEndpointGroupResponse(
    contactPostPassDurationSeconds: Optional[
      DataflowEndpointGroupDurationInSeconds
    ] = Optional.Absent,
    contactPrePassDurationSeconds: Optional[
      DataflowEndpointGroupDurationInSeconds
    ] = Optional.Absent,
    dataflowEndpointGroupArn: Optional[DataflowEndpointGroupArn] =
      Optional.Absent,
    dataflowEndpointGroupId: Optional[Uuid] = Optional.Absent,
    endpointsDetails: Optional[
      Iterable[zio.aws.groundstation.model.EndpointDetails]
    ] = Optional.Absent,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.GetDataflowEndpointGroupResponse = {
    import GetDataflowEndpointGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.GetDataflowEndpointGroupResponse
      .builder()
      .optionallyWith(
        contactPostPassDurationSeconds.map(value =>
          DataflowEndpointGroupDurationInSeconds.unwrap(value): Integer
        )
      )(_.contactPostPassDurationSeconds)
      .optionallyWith(
        contactPrePassDurationSeconds.map(value =>
          DataflowEndpointGroupDurationInSeconds.unwrap(value): Integer
        )
      )(_.contactPrePassDurationSeconds)
      .optionallyWith(
        dataflowEndpointGroupArn.map(value =>
          DataflowEndpointGroupArn.unwrap(value): java.lang.String
        )
      )(_.dataflowEndpointGroupArn)
      .optionallyWith(
        dataflowEndpointGroupId.map(value =>
          Uuid.unwrap(value): java.lang.String
        )
      )(_.dataflowEndpointGroupId)
      .optionallyWith(
        endpointsDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.endpointsDetails)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.GetDataflowEndpointGroupResponse.ReadOnly =
    zio.aws.groundstation.model.GetDataflowEndpointGroupResponse
      .wrap(buildAwsValue())
}
object GetDataflowEndpointGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.GetDataflowEndpointGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.groundstation.model.GetDataflowEndpointGroupResponse =
      zio.aws.groundstation.model.GetDataflowEndpointGroupResponse(
        contactPostPassDurationSeconds.map(value => value),
        contactPrePassDurationSeconds.map(value => value),
        dataflowEndpointGroupArn.map(value => value),
        dataflowEndpointGroupId.map(value => value),
        endpointsDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value)
      )
    def contactPostPassDurationSeconds
        : Optional[DataflowEndpointGroupDurationInSeconds]
    def contactPrePassDurationSeconds
        : Optional[DataflowEndpointGroupDurationInSeconds]
    def dataflowEndpointGroupArn: Optional[DataflowEndpointGroupArn]
    def dataflowEndpointGroupId: Optional[Uuid]
    def endpointsDetails
        : Optional[List[zio.aws.groundstation.model.EndpointDetails.ReadOnly]]
    def tags: Optional[Map[String, String]]
    def getContactPostPassDurationSeconds
        : ZIO[Any, AwsError, DataflowEndpointGroupDurationInSeconds] =
      AwsError.unwrapOptionField(
        "contactPostPassDurationSeconds",
        contactPostPassDurationSeconds
      )
    def getContactPrePassDurationSeconds
        : ZIO[Any, AwsError, DataflowEndpointGroupDurationInSeconds] =
      AwsError.unwrapOptionField(
        "contactPrePassDurationSeconds",
        contactPrePassDurationSeconds
      )
    def getDataflowEndpointGroupArn
        : ZIO[Any, AwsError, DataflowEndpointGroupArn] = AwsError
      .unwrapOptionField("dataflowEndpointGroupArn", dataflowEndpointGroupArn)
    def getDataflowEndpointGroupId: ZIO[Any, AwsError, Uuid] = AwsError
      .unwrapOptionField("dataflowEndpointGroupId", dataflowEndpointGroupId)
    def getEndpointsDetails: ZIO[Any, AwsError, List[
      zio.aws.groundstation.model.EndpointDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("endpointsDetails", endpointsDetails)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.GetDataflowEndpointGroupResponse
  ) extends zio.aws.groundstation.model.GetDataflowEndpointGroupResponse.ReadOnly {
    override val contactPostPassDurationSeconds
        : Optional[DataflowEndpointGroupDurationInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contactPostPassDurationSeconds())
        .map(value =>
          zio.aws.groundstation.model.primitives
            .DataflowEndpointGroupDurationInSeconds(value)
        )
    override val contactPrePassDurationSeconds
        : Optional[DataflowEndpointGroupDurationInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contactPrePassDurationSeconds())
        .map(value =>
          zio.aws.groundstation.model.primitives
            .DataflowEndpointGroupDurationInSeconds(value)
        )
    override val dataflowEndpointGroupArn: Optional[DataflowEndpointGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataflowEndpointGroupArn())
        .map(value =>
          zio.aws.groundstation.model.primitives.DataflowEndpointGroupArn(value)
        )
    override val dataflowEndpointGroupId: Optional[Uuid] = zio.aws.core.internal
      .optionalFromNullable(impl.dataflowEndpointGroupId())
      .map(value => zio.aws.groundstation.model.primitives.Uuid(value))
    override val endpointsDetails
        : Optional[List[zio.aws.groundstation.model.EndpointDetails.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointsDetails())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.groundstation.model.EndpointDetails.wrap(item)
          }.toList
        )
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.GetDataflowEndpointGroupResponse
  ): zio.aws.groundstation.model.GetDataflowEndpointGroupResponse.ReadOnly =
    new Wrapper(impl)
}
