package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.Uuid
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetAgentConfigurationRequest(agentId: Uuid) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.GetAgentConfigurationRequest = {
    import GetAgentConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.GetAgentConfigurationRequest
      .builder()
      .agentId(Uuid.unwrap(agentId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.GetAgentConfigurationRequest.ReadOnly =
    zio.aws.groundstation.model.GetAgentConfigurationRequest
      .wrap(buildAwsValue())
}
object GetAgentConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.GetAgentConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.GetAgentConfigurationRequest =
      zio.aws.groundstation.model.GetAgentConfigurationRequest(agentId)
    def agentId: Uuid
    def getAgentId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(agentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.GetAgentConfigurationRequest
  ) extends zio.aws.groundstation.model.GetAgentConfigurationRequest.ReadOnly {
    override val agentId: Uuid =
      zio.aws.groundstation.model.primitives.Uuid(impl.agentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.GetAgentConfigurationRequest
  ): zio.aws.groundstation.model.GetAgentConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
