package zio.aws.groundstation.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.groundstation.model.primitives.DataflowEndpointGroupDurationInSeconds
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateDataflowEndpointGroupRequest(
    contactPostPassDurationSeconds: Optional[
      DataflowEndpointGroupDurationInSeconds
    ] = Optional.Absent,
    contactPrePassDurationSeconds: Optional[
      DataflowEndpointGroupDurationInSeconds
    ] = Optional.Absent,
    endpointDetails: Iterable[zio.aws.groundstation.model.EndpointDetails],
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.CreateDataflowEndpointGroupRequest = {
    import CreateDataflowEndpointGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.CreateDataflowEndpointGroupRequest
      .builder()
      .optionallyWith(
        contactPostPassDurationSeconds.map(value =>
          DataflowEndpointGroupDurationInSeconds.unwrap(value): Integer
        )
      )(_.contactPostPassDurationSeconds)
      .optionallyWith(
        contactPrePassDurationSeconds.map(value =>
          DataflowEndpointGroupDurationInSeconds.unwrap(value): Integer
        )
      )(_.contactPrePassDurationSeconds)
      .endpointDetails(endpointDetails.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.CreateDataflowEndpointGroupRequest.ReadOnly =
    zio.aws.groundstation.model.CreateDataflowEndpointGroupRequest
      .wrap(buildAwsValue())
}
object CreateDataflowEndpointGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.CreateDataflowEndpointGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.groundstation.model.CreateDataflowEndpointGroupRequest =
      zio.aws.groundstation.model.CreateDataflowEndpointGroupRequest(
        contactPostPassDurationSeconds.map(value => value),
        contactPrePassDurationSeconds.map(value => value),
        endpointDetails.map { item =>
          item.asEditable
        },
        tags.map(value => value)
      )
    def contactPostPassDurationSeconds
        : Optional[DataflowEndpointGroupDurationInSeconds]
    def contactPrePassDurationSeconds
        : Optional[DataflowEndpointGroupDurationInSeconds]
    def endpointDetails
        : List[zio.aws.groundstation.model.EndpointDetails.ReadOnly]
    def tags: Optional[Map[String, String]]
    def getContactPostPassDurationSeconds
        : ZIO[Any, AwsError, DataflowEndpointGroupDurationInSeconds] =
      AwsError.unwrapOptionField(
        "contactPostPassDurationSeconds",
        contactPostPassDurationSeconds
      )
    def getContactPrePassDurationSeconds
        : ZIO[Any, AwsError, DataflowEndpointGroupDurationInSeconds] =
      AwsError.unwrapOptionField(
        "contactPrePassDurationSeconds",
        contactPrePassDurationSeconds
      )
    def getEndpointDetails: ZIO[Any, Nothing, List[
      zio.aws.groundstation.model.EndpointDetails.ReadOnly
    ]] = ZIO.succeed(endpointDetails)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.CreateDataflowEndpointGroupRequest
  ) extends zio.aws.groundstation.model.CreateDataflowEndpointGroupRequest.ReadOnly {
    override val contactPostPassDurationSeconds
        : Optional[DataflowEndpointGroupDurationInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contactPostPassDurationSeconds())
        .map(value =>
          zio.aws.groundstation.model.primitives
            .DataflowEndpointGroupDurationInSeconds(value)
        )
    override val contactPrePassDurationSeconds
        : Optional[DataflowEndpointGroupDurationInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contactPrePassDurationSeconds())
        .map(value =>
          zio.aws.groundstation.model.primitives
            .DataflowEndpointGroupDurationInSeconds(value)
        )
    override val endpointDetails
        : List[zio.aws.groundstation.model.EndpointDetails.ReadOnly] = impl
      .endpointDetails()
      .asScala
      .map { item =>
        zio.aws.groundstation.model.EndpointDetails.wrap(item)
      }
      .toList
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.CreateDataflowEndpointGroupRequest
  ): zio.aws.groundstation.model.CreateDataflowEndpointGroupRequest.ReadOnly =
    new Wrapper(impl)
}
