package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.SafeName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateConfigRequest(
    configData: zio.aws.groundstation.model.ConfigTypeData,
    name: SafeName,
    tags: Optional[Map[String, String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.CreateConfigRequest = {
    import CreateConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.CreateConfigRequest
      .builder()
      .configData(configData.buildAwsValue())
      .name(SafeName.unwrap(name): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.CreateConfigRequest.ReadOnly =
    zio.aws.groundstation.model.CreateConfigRequest.wrap(buildAwsValue())
}
object CreateConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.CreateConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.CreateConfigRequest =
      zio.aws.groundstation.model.CreateConfigRequest(
        configData.asEditable,
        name,
        tags.map(value => value)
      )
    def configData: zio.aws.groundstation.model.ConfigTypeData.ReadOnly
    def name: SafeName
    def tags: Optional[Map[String, String]]
    def getConfigData: ZIO[
      Any,
      Nothing,
      zio.aws.groundstation.model.ConfigTypeData.ReadOnly
    ] = ZIO.succeed(configData)
    def getName: ZIO[Any, Nothing, SafeName] = ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.CreateConfigRequest
  ) extends zio.aws.groundstation.model.CreateConfigRequest.ReadOnly {
    override val configData
        : zio.aws.groundstation.model.ConfigTypeData.ReadOnly =
      zio.aws.groundstation.model.ConfigTypeData.wrap(impl.configData())
    override val name: SafeName =
      zio.aws.groundstation.model.primitives.SafeName(impl.name())
    override val tags: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.CreateConfigRequest
  ): zio.aws.groundstation.model.CreateConfigRequest.ReadOnly = new Wrapper(
    impl
  )
}
