package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ConnectionDetails(
    mtu: Optional[Integer] = Optional.Absent,
    socketAddress: zio.aws.groundstation.model.SocketAddress
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.ConnectionDetails = {
    import ConnectionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.ConnectionDetails
      .builder()
      .optionallyWith(mtu.map(value => value: java.lang.Integer))(_.mtu)
      .socketAddress(socketAddress.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.ConnectionDetails.ReadOnly =
    zio.aws.groundstation.model.ConnectionDetails.wrap(buildAwsValue())
}
object ConnectionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.ConnectionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.ConnectionDetails =
      zio.aws.groundstation.model
        .ConnectionDetails(mtu.map(value => value), socketAddress.asEditable)
    def mtu: Optional[Integer]
    def socketAddress: zio.aws.groundstation.model.SocketAddress.ReadOnly
    def getMtu: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("mtu", mtu)
    def getSocketAddress: ZIO[
      Any,
      Nothing,
      zio.aws.groundstation.model.SocketAddress.ReadOnly
    ] = ZIO.succeed(socketAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.ConnectionDetails
  ) extends zio.aws.groundstation.model.ConnectionDetails.ReadOnly {
    override val mtu: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.mtu())
      .map(value => value: Integer)
    override val socketAddress
        : zio.aws.groundstation.model.SocketAddress.ReadOnly =
      zio.aws.groundstation.model.SocketAddress.wrap(impl.socketAddress())
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.ConnectionDetails
  ): zio.aws.groundstation.model.ConnectionDetails.ReadOnly = new Wrapper(impl)
}
