package zio.aws.groundstation.model
import scala.jdk.CollectionConverters.*
sealed trait CapabilityHealthReason {
  def unwrap: software.amazon.awssdk.services.groundstation.model.CapabilityHealthReason
}
object CapabilityHealthReason {
  def wrap(
      value: software.amazon.awssdk.services.groundstation.model.CapabilityHealthReason
  ): zio.aws.groundstation.model.CapabilityHealthReason = value match {
    case software.amazon.awssdk.services.groundstation.model.CapabilityHealthReason.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.groundstation.model.CapabilityHealthReason.NO_REGISTERED_AGENT =>
      val r = NO_REGISTERED_AGENT
      r
    case software.amazon.awssdk.services.groundstation.model.CapabilityHealthReason.INVALID_IP_OWNERSHIP =>
      val r = INVALID_IP_OWNERSHIP
      r
    case software.amazon.awssdk.services.groundstation.model.CapabilityHealthReason.NOT_AUTHORIZED_TO_CREATE_SLR =>
      val r = NOT_AUTHORIZED_TO_CREATE_SLR
      r
    case software.amazon.awssdk.services.groundstation.model.CapabilityHealthReason.UNVERIFIED_IP_OWNERSHIP =>
      val r = UNVERIFIED_IP_OWNERSHIP
      r
    case software.amazon.awssdk.services.groundstation.model.CapabilityHealthReason.INITIALIZING_DATAPLANE =>
      val r = INITIALIZING_DATAPLANE
      r
    case software.amazon.awssdk.services.groundstation.model.CapabilityHealthReason.DATAPLANE_FAILURE =>
      val r = DATAPLANE_FAILURE
      r
    case software.amazon.awssdk.services.groundstation.model.CapabilityHealthReason.HEALTHY =>
      val r = HEALTHY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.groundstation.model.CapabilityHealthReason {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.CapabilityHealthReason =
      software.amazon.awssdk.services.groundstation.model.CapabilityHealthReason.UNKNOWN_TO_SDK_VERSION
  }
  case object NO_REGISTERED_AGENT
      extends zio.aws.groundstation.model.CapabilityHealthReason {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.CapabilityHealthReason =
      software.amazon.awssdk.services.groundstation.model.CapabilityHealthReason.NO_REGISTERED_AGENT
  }
  case object INVALID_IP_OWNERSHIP
      extends zio.aws.groundstation.model.CapabilityHealthReason {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.CapabilityHealthReason =
      software.amazon.awssdk.services.groundstation.model.CapabilityHealthReason.INVALID_IP_OWNERSHIP
  }
  case object NOT_AUTHORIZED_TO_CREATE_SLR
      extends zio.aws.groundstation.model.CapabilityHealthReason {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.CapabilityHealthReason =
      software.amazon.awssdk.services.groundstation.model.CapabilityHealthReason.NOT_AUTHORIZED_TO_CREATE_SLR
  }
  case object UNVERIFIED_IP_OWNERSHIP
      extends zio.aws.groundstation.model.CapabilityHealthReason {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.CapabilityHealthReason =
      software.amazon.awssdk.services.groundstation.model.CapabilityHealthReason.UNVERIFIED_IP_OWNERSHIP
  }
  case object INITIALIZING_DATAPLANE
      extends zio.aws.groundstation.model.CapabilityHealthReason {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.CapabilityHealthReason =
      software.amazon.awssdk.services.groundstation.model.CapabilityHealthReason.INITIALIZING_DATAPLANE
  }
  case object DATAPLANE_FAILURE
      extends zio.aws.groundstation.model.CapabilityHealthReason {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.CapabilityHealthReason =
      software.amazon.awssdk.services.groundstation.model.CapabilityHealthReason.DATAPLANE_FAILURE
  }
  case object HEALTHY
      extends zio.aws.groundstation.model.CapabilityHealthReason {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.CapabilityHealthReason =
      software.amazon.awssdk.services.groundstation.model.CapabilityHealthReason.HEALTHY
  }
}
