package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.{
  InstanceType,
  InstanceId,
  VersionString,
  Integer
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AgentDetails(
    agentCpuCores: Optional[Iterable[Integer]] = Optional.Absent,
    agentVersion: VersionString,
    componentVersions: Iterable[zio.aws.groundstation.model.ComponentVersion],
    instanceId: InstanceId,
    instanceType: InstanceType,
    reservedCpuCores: Optional[Iterable[Integer]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.AgentDetails = {
    import AgentDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.AgentDetails
      .builder()
      .optionallyWith(
        agentCpuCores.map(value =>
          value.map { item =>
            item: java.lang.Integer
          }.asJavaCollection
        )
      )(_.agentCpuCores)
      .agentVersion(VersionString.unwrap(agentVersion): java.lang.String)
      .componentVersions(componentVersions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .instanceType(InstanceType.unwrap(instanceType): java.lang.String)
      .optionallyWith(
        reservedCpuCores.map(value =>
          value.map { item =>
            item: java.lang.Integer
          }.asJavaCollection
        )
      )(_.reservedCpuCores)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.AgentDetails.ReadOnly =
    zio.aws.groundstation.model.AgentDetails.wrap(buildAwsValue())
}
object AgentDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.AgentDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.AgentDetails =
      zio.aws.groundstation.model.AgentDetails(
        agentCpuCores.map(value => value),
        agentVersion,
        componentVersions.map { item =>
          item.asEditable
        },
        instanceId,
        instanceType,
        reservedCpuCores.map(value => value)
      )
    def agentCpuCores: Optional[List[Integer]]
    def agentVersion: VersionString
    def componentVersions
        : List[zio.aws.groundstation.model.ComponentVersion.ReadOnly]
    def instanceId: InstanceId
    def instanceType: InstanceType
    def reservedCpuCores: Optional[List[Integer]]
    def getAgentCpuCores: ZIO[Any, AwsError, List[Integer]] =
      AwsError.unwrapOptionField("agentCpuCores", agentCpuCores)
    def getAgentVersion: ZIO[Any, Nothing, VersionString] =
      ZIO.succeed(agentVersion)
    def getComponentVersions: ZIO[Any, Nothing, List[
      zio.aws.groundstation.model.ComponentVersion.ReadOnly
    ]] = ZIO.succeed(componentVersions)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getInstanceType: ZIO[Any, Nothing, InstanceType] =
      ZIO.succeed(instanceType)
    def getReservedCpuCores: ZIO[Any, AwsError, List[Integer]] =
      AwsError.unwrapOptionField("reservedCpuCores", reservedCpuCores)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.AgentDetails
  ) extends zio.aws.groundstation.model.AgentDetails.ReadOnly {
    override val agentCpuCores: Optional[List[Integer]] = zio.aws.core.internal
      .optionalFromNullable(impl.agentCpuCores())
      .map(value =>
        value.asScala.map { item =>
          item: Integer
        }.toList
      )
    override val agentVersion: VersionString =
      zio.aws.groundstation.model.primitives.VersionString(impl.agentVersion())
    override val componentVersions
        : List[zio.aws.groundstation.model.ComponentVersion.ReadOnly] = impl
      .componentVersions()
      .asScala
      .map { item =>
        zio.aws.groundstation.model.ComponentVersion.wrap(item)
      }
      .toList
    override val instanceId: InstanceId =
      zio.aws.groundstation.model.primitives.InstanceId(impl.instanceId())
    override val instanceType: InstanceType =
      zio.aws.groundstation.model.primitives.InstanceType(impl.instanceType())
    override val reservedCpuCores: Optional[List[Integer]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedCpuCores())
        .map(value =>
          value.asScala.map { item =>
            item: Integer
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.AgentDetails
  ): zio.aws.groundstation.model.AgentDetails.ReadOnly = new Wrapper(impl)
}
