package zio.aws.groundstation
import zio.aws.groundstation.model.RegisterAgentResponse.ReadOnly
import software.amazon.awssdk.services.groundstation.GroundStationAsyncClient
import zio.mock.{Proxy, Mock}
import zio.aws.groundstation.model.{
  CreateDataflowEndpointGroupRequest,
  ListMissionProfilesRequest,
  UpdateConfigRequest,
  ListConfigsRequest,
  UpdateEphemerisRequest,
  RegisterAgentRequest,
  UpdateMissionProfileRequest,
  CreateEphemerisRequest,
  GetMissionProfileRequest,
  ListDataflowEndpointGroupsRequest,
  UpdateAgentStatusRequest,
  ListTagsForResourceRequest,
  CancelContactRequest,
  DeleteDataflowEndpointGroupRequest,
  GetDataflowEndpointGroupRequest,
  CreateMissionProfileRequest,
  DeleteEphemerisRequest,
  ListGroundStationsRequest,
  DescribeEphemerisRequest,
  GetAgentConfigurationRequest,
  DeleteMissionProfileRequest,
  GetMinuteUsageRequest,
  CreateConfigRequest,
  DescribeContactRequest,
  GetSatelliteRequest,
  GetConfigRequest,
  ListEphemeridesRequest,
  UntagResourceRequest,
  ListContactsRequest,
  DeleteConfigRequest,
  ListSatellitesRequest,
  TagResourceRequest,
  ReserveContactRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object GroundStationMock extends Mock[GroundStation] {
  object CreateConfig
      extends Effect[
        CreateConfigRequest,
        AwsError,
        zio.aws.groundstation.model.CreateConfigResponse.ReadOnly
      ]
  object ListConfigs
      extends Stream[
        ListConfigsRequest,
        AwsError,
        zio.aws.groundstation.model.ConfigListItem.ReadOnly
      ]
  object ListConfigsPaginated
      extends Effect[
        ListConfigsRequest,
        AwsError,
        zio.aws.groundstation.model.ListConfigsResponse.ReadOnly
      ]
  object DeleteConfig
      extends Effect[
        DeleteConfigRequest,
        AwsError,
        zio.aws.groundstation.model.DeleteConfigResponse.ReadOnly
      ]
  object CancelContact
      extends Effect[
        CancelContactRequest,
        AwsError,
        zio.aws.groundstation.model.CancelContactResponse.ReadOnly
      ]
  object GetMinuteUsage
      extends Effect[
        GetMinuteUsageRequest,
        AwsError,
        zio.aws.groundstation.model.GetMinuteUsageResponse.ReadOnly
      ]
  object ListMissionProfiles
      extends Stream[
        ListMissionProfilesRequest,
        AwsError,
        zio.aws.groundstation.model.MissionProfileListItem.ReadOnly
      ]
  object ListMissionProfilesPaginated
      extends Effect[
        ListMissionProfilesRequest,
        AwsError,
        zio.aws.groundstation.model.ListMissionProfilesResponse.ReadOnly
      ]
  object GetDataflowEndpointGroup
      extends Effect[
        GetDataflowEndpointGroupRequest,
        AwsError,
        zio.aws.groundstation.model.GetDataflowEndpointGroupResponse.ReadOnly
      ]
  object CreateDataflowEndpointGroup
      extends Effect[
        CreateDataflowEndpointGroupRequest,
        AwsError,
        zio.aws.groundstation.model.CreateDataflowEndpointGroupResponse.ReadOnly
      ]
  object UpdateMissionProfile
      extends Effect[
        UpdateMissionProfileRequest,
        AwsError,
        zio.aws.groundstation.model.UpdateMissionProfileResponse.ReadOnly
      ]
  object UpdateAgentStatus
      extends Effect[
        UpdateAgentStatusRequest,
        AwsError,
        zio.aws.groundstation.model.UpdateAgentStatusResponse.ReadOnly
      ]
  object GetConfig
      extends Effect[
        GetConfigRequest,
        AwsError,
        zio.aws.groundstation.model.GetConfigResponse.ReadOnly
      ]
  object DeleteEphemeris
      extends Effect[
        DeleteEphemerisRequest,
        AwsError,
        zio.aws.groundstation.model.DeleteEphemerisResponse.ReadOnly
      ]
  object UpdateEphemeris
      extends Effect[
        UpdateEphemerisRequest,
        AwsError,
        zio.aws.groundstation.model.UpdateEphemerisResponse.ReadOnly
      ]
  object ListSatellites
      extends Stream[
        ListSatellitesRequest,
        AwsError,
        zio.aws.groundstation.model.SatelliteListItem.ReadOnly
      ]
  object ListSatellitesPaginated
      extends Effect[
        ListSatellitesRequest,
        AwsError,
        zio.aws.groundstation.model.ListSatellitesResponse.ReadOnly
      ]
  object ListEphemerides
      extends Stream[
        ListEphemeridesRequest,
        AwsError,
        zio.aws.groundstation.model.EphemerisItem.ReadOnly
      ]
  object ListEphemeridesPaginated
      extends Effect[
        ListEphemeridesRequest,
        AwsError,
        zio.aws.groundstation.model.ListEphemeridesResponse.ReadOnly
      ]
  object GetSatellite
      extends Effect[
        GetSatelliteRequest,
        AwsError,
        zio.aws.groundstation.model.GetSatelliteResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.groundstation.model.UntagResourceResponse.ReadOnly
      ]
  object DescribeContact
      extends Effect[
        DescribeContactRequest,
        AwsError,
        zio.aws.groundstation.model.DescribeContactResponse.ReadOnly
      ]
  object CreateEphemeris
      extends Effect[
        CreateEphemerisRequest,
        AwsError,
        zio.aws.groundstation.model.CreateEphemerisResponse.ReadOnly
      ]
  object GetAgentConfiguration
      extends Effect[
        GetAgentConfigurationRequest,
        AwsError,
        zio.aws.groundstation.model.GetAgentConfigurationResponse.ReadOnly
      ]
  object DescribeEphemeris
      extends Effect[
        DescribeEphemerisRequest,
        AwsError,
        zio.aws.groundstation.model.DescribeEphemerisResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.groundstation.model.ListTagsForResourceResponse.ReadOnly
      ]
  object DeleteMissionProfile
      extends Effect[
        DeleteMissionProfileRequest,
        AwsError,
        zio.aws.groundstation.model.DeleteMissionProfileResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.groundstation.model.TagResourceResponse.ReadOnly
      ]
  object RegisterAgent extends Effect[RegisterAgentRequest, AwsError, ReadOnly]
  object GetMissionProfile
      extends Effect[
        GetMissionProfileRequest,
        AwsError,
        zio.aws.groundstation.model.GetMissionProfileResponse.ReadOnly
      ]
  object ListContacts
      extends Stream[
        ListContactsRequest,
        AwsError,
        zio.aws.groundstation.model.ContactData.ReadOnly
      ]
  object ListContactsPaginated
      extends Effect[
        ListContactsRequest,
        AwsError,
        zio.aws.groundstation.model.ListContactsResponse.ReadOnly
      ]
  object DeleteDataflowEndpointGroup
      extends Effect[
        DeleteDataflowEndpointGroupRequest,
        AwsError,
        zio.aws.groundstation.model.DeleteDataflowEndpointGroupResponse.ReadOnly
      ]
  object ReserveContact
      extends Effect[
        ReserveContactRequest,
        AwsError,
        zio.aws.groundstation.model.ReserveContactResponse.ReadOnly
      ]
  object CreateMissionProfile
      extends Effect[
        CreateMissionProfileRequest,
        AwsError,
        zio.aws.groundstation.model.CreateMissionProfileResponse.ReadOnly
      ]
  object UpdateConfig
      extends Effect[
        UpdateConfigRequest,
        AwsError,
        zio.aws.groundstation.model.UpdateConfigResponse.ReadOnly
      ]
  object ListGroundStations
      extends Stream[
        ListGroundStationsRequest,
        AwsError,
        zio.aws.groundstation.model.GroundStationData.ReadOnly
      ]
  object ListGroundStationsPaginated
      extends Effect[
        ListGroundStationsRequest,
        AwsError,
        zio.aws.groundstation.model.ListGroundStationsResponse.ReadOnly
      ]
  object ListDataflowEndpointGroups
      extends Stream[
        ListDataflowEndpointGroupsRequest,
        AwsError,
        zio.aws.groundstation.model.DataflowEndpointListItem.ReadOnly
      ]
  object ListDataflowEndpointGroupsPaginated
      extends Effect[
        ListDataflowEndpointGroupsRequest,
        AwsError,
        zio.aws.groundstation.model.ListDataflowEndpointGroupsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, GroundStation] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, GroundStation] { rts =>
        zio.ZIO.succeed {
          new GroundStation {
            val api: GroundStationAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): GroundStation = this
            def createConfig(request: CreateConfigRequest): IO[
              AwsError,
              zio.aws.groundstation.model.CreateConfigResponse.ReadOnly
            ] = proxy(CreateConfig, request)
            def listConfigs(request: ListConfigsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.groundstation.model.ConfigListItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListConfigs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listConfigsPaginated(request: ListConfigsRequest): IO[
              AwsError,
              zio.aws.groundstation.model.ListConfigsResponse.ReadOnly
            ] = proxy(ListConfigsPaginated, request)
            def deleteConfig(request: DeleteConfigRequest): IO[
              AwsError,
              zio.aws.groundstation.model.DeleteConfigResponse.ReadOnly
            ] = proxy(DeleteConfig, request)
            def cancelContact(request: CancelContactRequest): IO[
              AwsError,
              zio.aws.groundstation.model.CancelContactResponse.ReadOnly
            ] = proxy(CancelContact, request)
            def getMinuteUsage(request: GetMinuteUsageRequest): IO[
              AwsError,
              zio.aws.groundstation.model.GetMinuteUsageResponse.ReadOnly
            ] = proxy(GetMinuteUsage, request)
            def listMissionProfiles(
                request: ListMissionProfilesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.groundstation.model.MissionProfileListItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListMissionProfiles, request)
                }
                .getOrThrowFiberFailure()
            }
            def listMissionProfilesPaginated(
                request: ListMissionProfilesRequest
            ): IO[
              AwsError,
              zio.aws.groundstation.model.ListMissionProfilesResponse.ReadOnly
            ] = proxy(ListMissionProfilesPaginated, request)
            def getDataflowEndpointGroup(
                request: GetDataflowEndpointGroupRequest
            ): IO[
              AwsError,
              zio.aws.groundstation.model.GetDataflowEndpointGroupResponse.ReadOnly
            ] = proxy(GetDataflowEndpointGroup, request)
            def createDataflowEndpointGroup(
                request: CreateDataflowEndpointGroupRequest
            ): IO[
              AwsError,
              zio.aws.groundstation.model.CreateDataflowEndpointGroupResponse.ReadOnly
            ] = proxy(CreateDataflowEndpointGroup, request)
            def updateMissionProfile(request: UpdateMissionProfileRequest): IO[
              AwsError,
              zio.aws.groundstation.model.UpdateMissionProfileResponse.ReadOnly
            ] = proxy(UpdateMissionProfile, request)
            def updateAgentStatus(request: UpdateAgentStatusRequest): IO[
              AwsError,
              zio.aws.groundstation.model.UpdateAgentStatusResponse.ReadOnly
            ] = proxy(UpdateAgentStatus, request)
            def getConfig(request: GetConfigRequest): IO[
              AwsError,
              zio.aws.groundstation.model.GetConfigResponse.ReadOnly
            ] = proxy(GetConfig, request)
            def deleteEphemeris(request: DeleteEphemerisRequest): IO[
              AwsError,
              zio.aws.groundstation.model.DeleteEphemerisResponse.ReadOnly
            ] = proxy(DeleteEphemeris, request)
            def updateEphemeris(request: UpdateEphemerisRequest): IO[
              AwsError,
              zio.aws.groundstation.model.UpdateEphemerisResponse.ReadOnly
            ] = proxy(UpdateEphemeris, request)
            def listSatellites(request: ListSatellitesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.groundstation.model.SatelliteListItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSatellites, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSatellitesPaginated(request: ListSatellitesRequest): IO[
              AwsError,
              zio.aws.groundstation.model.ListSatellitesResponse.ReadOnly
            ] = proxy(ListSatellitesPaginated, request)
            def listEphemerides(request: ListEphemeridesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.groundstation.model.EphemerisItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEphemerides, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEphemeridesPaginated(request: ListEphemeridesRequest): IO[
              AwsError,
              zio.aws.groundstation.model.ListEphemeridesResponse.ReadOnly
            ] = proxy(ListEphemeridesPaginated, request)
            def getSatellite(request: GetSatelliteRequest): IO[
              AwsError,
              zio.aws.groundstation.model.GetSatelliteResponse.ReadOnly
            ] = proxy(GetSatellite, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.groundstation.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def describeContact(request: DescribeContactRequest): IO[
              AwsError,
              zio.aws.groundstation.model.DescribeContactResponse.ReadOnly
            ] = proxy(DescribeContact, request)
            def createEphemeris(request: CreateEphemerisRequest): IO[
              AwsError,
              zio.aws.groundstation.model.CreateEphemerisResponse.ReadOnly
            ] = proxy(CreateEphemeris, request)
            def getAgentConfiguration(
                request: GetAgentConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.groundstation.model.GetAgentConfigurationResponse.ReadOnly
            ] = proxy(GetAgentConfiguration, request)
            def describeEphemeris(request: DescribeEphemerisRequest): IO[
              AwsError,
              zio.aws.groundstation.model.DescribeEphemerisResponse.ReadOnly
            ] = proxy(DescribeEphemeris, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.groundstation.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def deleteMissionProfile(request: DeleteMissionProfileRequest): IO[
              AwsError,
              zio.aws.groundstation.model.DeleteMissionProfileResponse.ReadOnly
            ] = proxy(DeleteMissionProfile, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.groundstation.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def registerAgent(
                request: RegisterAgentRequest
            ): IO[AwsError, ReadOnly] = proxy(RegisterAgent, request)
            def getMissionProfile(request: GetMissionProfileRequest): IO[
              AwsError,
              zio.aws.groundstation.model.GetMissionProfileResponse.ReadOnly
            ] = proxy(GetMissionProfile, request)
            def listContacts(request: ListContactsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.groundstation.model.ContactData.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListContacts, request)
                }
                .getOrThrowFiberFailure()
            }
            def listContactsPaginated(request: ListContactsRequest): IO[
              AwsError,
              zio.aws.groundstation.model.ListContactsResponse.ReadOnly
            ] = proxy(ListContactsPaginated, request)
            def deleteDataflowEndpointGroup(
                request: DeleteDataflowEndpointGroupRequest
            ): IO[
              AwsError,
              zio.aws.groundstation.model.DeleteDataflowEndpointGroupResponse.ReadOnly
            ] = proxy(DeleteDataflowEndpointGroup, request)
            def reserveContact(request: ReserveContactRequest): IO[
              AwsError,
              zio.aws.groundstation.model.ReserveContactResponse.ReadOnly
            ] = proxy(ReserveContact, request)
            def createMissionProfile(request: CreateMissionProfileRequest): IO[
              AwsError,
              zio.aws.groundstation.model.CreateMissionProfileResponse.ReadOnly
            ] = proxy(CreateMissionProfile, request)
            def updateConfig(request: UpdateConfigRequest): IO[
              AwsError,
              zio.aws.groundstation.model.UpdateConfigResponse.ReadOnly
            ] = proxy(UpdateConfig, request)
            def listGroundStations(request: ListGroundStationsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.groundstation.model.GroundStationData.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListGroundStations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listGroundStationsPaginated(
                request: ListGroundStationsRequest
            ): IO[
              AwsError,
              zio.aws.groundstation.model.ListGroundStationsResponse.ReadOnly
            ] = proxy(ListGroundStationsPaginated, request)
            def listDataflowEndpointGroups(
                request: ListDataflowEndpointGroupsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.groundstation.model.DataflowEndpointListItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDataflowEndpointGroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDataflowEndpointGroupsPaginated(
                request: ListDataflowEndpointGroupsRequest
            ): IO[
              AwsError,
              zio.aws.groundstation.model.ListDataflowEndpointGroupsResponse.ReadOnly
            ] = proxy(ListDataflowEndpointGroupsPaginated, request)
          }
        }
      }
    }
  }
}
