package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.Uuid
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RegisterAgentResponse(
    agentId: Optional[Uuid] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.RegisterAgentResponse = {
    import RegisterAgentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.RegisterAgentResponse
      .builder()
      .optionallyWith(
        agentId.map(value => Uuid.unwrap(value): java.lang.String)
      )(_.agentId)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.RegisterAgentResponse.ReadOnly =
    zio.aws.groundstation.model.RegisterAgentResponse.wrap(buildAwsValue())
}
object RegisterAgentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.RegisterAgentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.RegisterAgentResponse =
      zio.aws.groundstation.model
        .RegisterAgentResponse(agentId.map(value => value))
    def agentId: Optional[Uuid]
    def getAgentId: ZIO[Any, AwsError, Uuid] =
      AwsError.unwrapOptionField("agentId", agentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.RegisterAgentResponse
  ) extends zio.aws.groundstation.model.RegisterAgentResponse.ReadOnly {
    override val agentId: Optional[Uuid] = zio.aws.core.internal
      .optionalFromNullable(impl.agentId())
      .map(value => zio.aws.groundstation.model.primitives.Uuid(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.RegisterAgentResponse
  ): zio.aws.groundstation.model.RegisterAgentResponse.ReadOnly = new Wrapper(
    impl
  )
}
