package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.AnyArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(resourceArn: AnyArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(AnyArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.groundstation.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.ListTagsForResourceRequest =
      zio.aws.groundstation.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: AnyArn
    def getResourceArn: ZIO[Any, Nothing, AnyArn] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.ListTagsForResourceRequest
  ) extends zio.aws.groundstation.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: AnyArn =
      zio.aws.groundstation.model.primitives.AnyArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.ListTagsForResourceRequest
  ): zio.aws.groundstation.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
