package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListMissionProfilesResponse(
    missionProfileList: Optional[
      Iterable[zio.aws.groundstation.model.MissionProfileListItem]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.ListMissionProfilesResponse = {
    import ListMissionProfilesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.ListMissionProfilesResponse
      .builder()
      .optionallyWith(
        missionProfileList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.missionProfileList)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.ListMissionProfilesResponse.ReadOnly =
    zio.aws.groundstation.model.ListMissionProfilesResponse
      .wrap(buildAwsValue())
}
object ListMissionProfilesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.ListMissionProfilesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.ListMissionProfilesResponse =
      zio.aws.groundstation.model.ListMissionProfilesResponse(
        missionProfileList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def missionProfileList: Optional[
      List[zio.aws.groundstation.model.MissionProfileListItem.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def getMissionProfileList: ZIO[Any, AwsError, List[
      zio.aws.groundstation.model.MissionProfileListItem.ReadOnly
    ]] = AwsError.unwrapOptionField("missionProfileList", missionProfileList)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.ListMissionProfilesResponse
  ) extends zio.aws.groundstation.model.ListMissionProfilesResponse.ReadOnly {
    override val missionProfileList: Optional[
      List[zio.aws.groundstation.model.MissionProfileListItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.missionProfileList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.groundstation.model.MissionProfileListItem.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.groundstation.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.ListMissionProfilesResponse
  ): zio.aws.groundstation.model.ListMissionProfilesResponse.ReadOnly =
    new Wrapper(impl)
}
