package zio.aws.groundstation.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.groundstation.model.primitives.{SafeName, Timestamp, Uuid}
import scala.jdk.CollectionConverters.*
final case class EphemerisMetaData(
    ephemerisId: Optional[Uuid] = Optional.Absent,
    epoch: Optional[Timestamp] = Optional.Absent,
    name: Optional[SafeName] = Optional.Absent,
    source: zio.aws.groundstation.model.EphemerisSource
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.EphemerisMetaData = {
    import EphemerisMetaData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.EphemerisMetaData
      .builder()
      .optionallyWith(
        ephemerisId.map(value => Uuid.unwrap(value): java.lang.String)
      )(_.ephemerisId)
      .optionallyWith(epoch.map(value => Timestamp.unwrap(value): Instant))(
        _.epoch
      )
      .optionallyWith(
        name.map(value => SafeName.unwrap(value): java.lang.String)
      )(_.name)
      .source(source.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.EphemerisMetaData.ReadOnly =
    zio.aws.groundstation.model.EphemerisMetaData.wrap(buildAwsValue())
}
object EphemerisMetaData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.EphemerisMetaData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.EphemerisMetaData =
      zio.aws.groundstation.model.EphemerisMetaData(
        ephemerisId.map(value => value),
        epoch.map(value => value),
        name.map(value => value),
        source
      )
    def ephemerisId: Optional[Uuid]
    def epoch: Optional[Timestamp]
    def name: Optional[SafeName]
    def source: zio.aws.groundstation.model.EphemerisSource
    def getEphemerisId: ZIO[Any, AwsError, Uuid] =
      AwsError.unwrapOptionField("ephemerisId", ephemerisId)
    def getEpoch: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("epoch", epoch)
    def getName: ZIO[Any, AwsError, SafeName] =
      AwsError.unwrapOptionField("name", name)
    def getSource
        : ZIO[Any, Nothing, zio.aws.groundstation.model.EphemerisSource] =
      ZIO.succeed(source)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.EphemerisMetaData
  ) extends zio.aws.groundstation.model.EphemerisMetaData.ReadOnly {
    override val ephemerisId: Optional[Uuid] = zio.aws.core.internal
      .optionalFromNullable(impl.ephemerisId())
      .map(value => zio.aws.groundstation.model.primitives.Uuid(value))
    override val epoch: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.epoch())
      .map(value => zio.aws.groundstation.model.primitives.Timestamp(value))
    override val name: Optional[SafeName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.groundstation.model.primitives.SafeName(value))
    override val source: zio.aws.groundstation.model.EphemerisSource =
      zio.aws.groundstation.model.EphemerisSource.wrap(impl.source())
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.EphemerisMetaData
  ): zio.aws.groundstation.model.EphemerisMetaData.ReadOnly = new Wrapper(impl)
}
