package zio.aws.groundstation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EndpointDetails(
    awsGroundStationAgentEndpoint: Optional[
      zio.aws.groundstation.model.AwsGroundStationAgentEndpoint
    ] = Optional.Absent,
    endpoint: Optional[zio.aws.groundstation.model.DataflowEndpoint] =
      Optional.Absent,
    healthReasons: Optional[
      Iterable[zio.aws.groundstation.model.CapabilityHealthReason]
    ] = Optional.Absent,
    healthStatus: Optional[zio.aws.groundstation.model.CapabilityHealth] =
      Optional.Absent,
    securityDetails: Optional[zio.aws.groundstation.model.SecurityDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.EndpointDetails = {
    import EndpointDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.EndpointDetails
      .builder()
      .optionallyWith(
        awsGroundStationAgentEndpoint.map(value => value.buildAwsValue())
      )(_.awsGroundStationAgentEndpoint)
      .optionallyWith(endpoint.map(value => value.buildAwsValue()))(_.endpoint)
      .optionallyWith(
        healthReasons.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.healthReasonsWithStrings)
      .optionallyWith(healthStatus.map(value => value.unwrap))(_.healthStatus)
      .optionallyWith(securityDetails.map(value => value.buildAwsValue()))(
        _.securityDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.EndpointDetails.ReadOnly =
    zio.aws.groundstation.model.EndpointDetails.wrap(buildAwsValue())
}
object EndpointDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.EndpointDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.EndpointDetails =
      zio.aws.groundstation.model.EndpointDetails(
        awsGroundStationAgentEndpoint.map(value => value.asEditable),
        endpoint.map(value => value.asEditable),
        healthReasons.map(value => value),
        healthStatus.map(value => value),
        securityDetails.map(value => value.asEditable)
      )
    def awsGroundStationAgentEndpoint: Optional[
      zio.aws.groundstation.model.AwsGroundStationAgentEndpoint.ReadOnly
    ]
    def endpoint
        : Optional[zio.aws.groundstation.model.DataflowEndpoint.ReadOnly]
    def healthReasons
        : Optional[List[zio.aws.groundstation.model.CapabilityHealthReason]]
    def healthStatus: Optional[zio.aws.groundstation.model.CapabilityHealth]
    def securityDetails
        : Optional[zio.aws.groundstation.model.SecurityDetails.ReadOnly]
    def getAwsGroundStationAgentEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.groundstation.model.AwsGroundStationAgentEndpoint.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsGroundStationAgentEndpoint",
      awsGroundStationAgentEndpoint
    )
    def getEndpoint: ZIO[
      Any,
      AwsError,
      zio.aws.groundstation.model.DataflowEndpoint.ReadOnly
    ] = AwsError.unwrapOptionField("endpoint", endpoint)
    def getHealthReasons: ZIO[Any, AwsError, List[
      zio.aws.groundstation.model.CapabilityHealthReason
    ]] = AwsError.unwrapOptionField("healthReasons", healthReasons)
    def getHealthStatus
        : ZIO[Any, AwsError, zio.aws.groundstation.model.CapabilityHealth] =
      AwsError.unwrapOptionField("healthStatus", healthStatus)
    def getSecurityDetails: ZIO[
      Any,
      AwsError,
      zio.aws.groundstation.model.SecurityDetails.ReadOnly
    ] = AwsError.unwrapOptionField("securityDetails", securityDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.EndpointDetails
  ) extends zio.aws.groundstation.model.EndpointDetails.ReadOnly {
    override val awsGroundStationAgentEndpoint: Optional[
      zio.aws.groundstation.model.AwsGroundStationAgentEndpoint.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.awsGroundStationAgentEndpoint())
      .map(value =>
        zio.aws.groundstation.model.AwsGroundStationAgentEndpoint.wrap(value)
      )
    override val endpoint
        : Optional[zio.aws.groundstation.model.DataflowEndpoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpoint())
        .map(value => zio.aws.groundstation.model.DataflowEndpoint.wrap(value))
    override val healthReasons
        : Optional[List[zio.aws.groundstation.model.CapabilityHealthReason]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.healthReasons())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.groundstation.model.CapabilityHealthReason.wrap(item)
          }.toList
        )
    override val healthStatus
        : Optional[zio.aws.groundstation.model.CapabilityHealth] =
      zio.aws.core.internal
        .optionalFromNullable(impl.healthStatus())
        .map(value => zio.aws.groundstation.model.CapabilityHealth.wrap(value))
    override val securityDetails
        : Optional[zio.aws.groundstation.model.SecurityDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityDetails())
        .map(value => zio.aws.groundstation.model.SecurityDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.EndpointDetails
  ): zio.aws.groundstation.model.EndpointDetails.ReadOnly = new Wrapper(impl)
}
