package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.Uuid
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeEphemerisRequest(ephemerisId: Uuid) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.DescribeEphemerisRequest = {
    import DescribeEphemerisRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.DescribeEphemerisRequest
      .builder()
      .ephemerisId(Uuid.unwrap(ephemerisId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.groundstation.model.DescribeEphemerisRequest.ReadOnly =
    zio.aws.groundstation.model.DescribeEphemerisRequest.wrap(buildAwsValue())
}
object DescribeEphemerisRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.DescribeEphemerisRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.DescribeEphemerisRequest =
      zio.aws.groundstation.model.DescribeEphemerisRequest(ephemerisId)
    def ephemerisId: Uuid
    def getEphemerisId: ZIO[Any, Nothing, Uuid] = ZIO.succeed(ephemerisId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.DescribeEphemerisRequest
  ) extends zio.aws.groundstation.model.DescribeEphemerisRequest.ReadOnly {
    override val ephemerisId: Uuid =
      zio.aws.groundstation.model.primitives.Uuid(impl.ephemerisId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.DescribeEphemerisRequest
  ): zio.aws.groundstation.model.DescribeEphemerisRequest.ReadOnly =
    new Wrapper(impl)
}
