package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.Uuid
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateEphemerisResponse(
    ephemerisId: Optional[Uuid] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.CreateEphemerisResponse = {
    import CreateEphemerisResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.CreateEphemerisResponse
      .builder()
      .optionallyWith(
        ephemerisId.map(value => Uuid.unwrap(value): java.lang.String)
      )(_.ephemerisId)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.CreateEphemerisResponse.ReadOnly =
    zio.aws.groundstation.model.CreateEphemerisResponse.wrap(buildAwsValue())
}
object CreateEphemerisResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.CreateEphemerisResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.CreateEphemerisResponse =
      zio.aws.groundstation.model
        .CreateEphemerisResponse(ephemerisId.map(value => value))
    def ephemerisId: Optional[Uuid]
    def getEphemerisId: ZIO[Any, AwsError, Uuid] =
      AwsError.unwrapOptionField("ephemerisId", ephemerisId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.CreateEphemerisResponse
  ) extends zio.aws.groundstation.model.CreateEphemerisResponse.ReadOnly {
    override val ephemerisId: Optional[Uuid] = zio.aws.core.internal
      .optionalFromNullable(impl.ephemerisId())
      .map(value => zio.aws.groundstation.model.primitives.Uuid(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.CreateEphemerisResponse
  ): zio.aws.groundstation.model.CreateEphemerisResponse.ReadOnly = new Wrapper(
    impl
  )
}
