package zio.aws.groundstation.model
import scala.jdk.CollectionConverters.*
sealed trait CapabilityHealth {
  def unwrap
      : software.amazon.awssdk.services.groundstation.model.CapabilityHealth
}
object CapabilityHealth {
  def wrap(
      value: software.amazon.awssdk.services.groundstation.model.CapabilityHealth
  ): zio.aws.groundstation.model.CapabilityHealth = value match {
    case software.amazon.awssdk.services.groundstation.model.CapabilityHealth.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.groundstation.model.CapabilityHealth.UNHEALTHY =>
      val r = UNHEALTHY
      r
    case software.amazon.awssdk.services.groundstation.model.CapabilityHealth.HEALTHY =>
      val r = HEALTHY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.groundstation.model.CapabilityHealth {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.CapabilityHealth =
      software.amazon.awssdk.services.groundstation.model.CapabilityHealth.UNKNOWN_TO_SDK_VERSION
  }
  case object UNHEALTHY extends zio.aws.groundstation.model.CapabilityHealth {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.CapabilityHealth =
      software.amazon.awssdk.services.groundstation.model.CapabilityHealth.UNHEALTHY
  }
  case object HEALTHY extends zio.aws.groundstation.model.CapabilityHealth {
    override def unwrap
        : software.amazon.awssdk.services.groundstation.model.CapabilityHealth =
      software.amazon.awssdk.services.groundstation.model.CapabilityHealth.HEALTHY
  }
}
