package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class TimeRange(endTime: Timestamp, startTime: Timestamp) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.TimeRange = {
    import TimeRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.TimeRange
      .builder()
      .endTime(Timestamp.unwrap(endTime): Instant)
      .startTime(Timestamp.unwrap(startTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.TimeRange.ReadOnly =
    zio.aws.groundstation.model.TimeRange.wrap(buildAwsValue())
}
object TimeRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.TimeRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.TimeRange =
      zio.aws.groundstation.model.TimeRange(endTime, startTime)
    def endTime: Timestamp
    def startTime: Timestamp
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.TimeRange
  ) extends zio.aws.groundstation.model.TimeRange.ReadOnly {
    override val endTime: Timestamp =
      zio.aws.groundstation.model.primitives.Timestamp(impl.endTime())
    override val startTime: Timestamp =
      zio.aws.groundstation.model.primitives.Timestamp(impl.startTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.TimeRange
  ): zio.aws.groundstation.model.TimeRange.ReadOnly = new Wrapper(impl)
}
