package zio.aws.groundstation.model
import zio.aws.groundstation.model.primitives.RoleArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SecurityDetails(
    roleArn: RoleArn,
    securityGroupIds: Iterable[String],
    subnetIds: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.groundstation.model.SecurityDetails = {
    import SecurityDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.groundstation.model.SecurityDetails
      .builder()
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .securityGroupIds(securityGroupIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .subnetIds(subnetIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.groundstation.model.SecurityDetails.ReadOnly =
    zio.aws.groundstation.model.SecurityDetails.wrap(buildAwsValue())
}
object SecurityDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.groundstation.model.SecurityDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.groundstation.model.SecurityDetails =
      zio.aws.groundstation.model
        .SecurityDetails(roleArn, securityGroupIds, subnetIds)
    def roleArn: RoleArn
    def securityGroupIds: List[String]
    def subnetIds: List[String]
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getSecurityGroupIds: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(securityGroupIds)
    def getSubnetIds: ZIO[Any, Nothing, List[String]] = ZIO.succeed(subnetIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.groundstation.model.SecurityDetails
  ) extends zio.aws.groundstation.model.SecurityDetails.ReadOnly {
    override val roleArn: RoleArn =
      zio.aws.groundstation.model.primitives.RoleArn(impl.roleArn())
    override val securityGroupIds: List[String] = impl
      .securityGroupIds()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val subnetIds: List[String] = impl
      .subnetIds()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.groundstation.model.SecurityDetails
  ): zio.aws.groundstation.model.SecurityDetails.ReadOnly = new Wrapper(impl)
}
